<?php
//Include Common Files @1-7679E4EB
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "mst_vendor_vehicle.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-DF385382
include_once(RelativePath . "/incl_left_panel.php");
//End Include Page implementation

//Include Page implementation @3-73D590C4
include_once(RelativePath . "/incl_header.php");
//End Include Page implementation

//Include Page implementation @4-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

class clsGridclix_list { //clix_list class @5-9A031AD4

//Variables @5-6E51DF5A

    // Public variables
    public $ComponentType = "Grid";
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $ErrorBlock;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $ForceIteration = false;
    public $HasRecord = false;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $RowNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";
    public $Attributes;

    // Grid Controls
    public $StaticControls;
    public $RowControls;
//End Variables

//Class_Initialize Event @5-522987C9
    function clsGridclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 2000;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 2000)
            $this->PageSize = 2000;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->vendor_name = new clsControl(ccsLabel, "vendor_name", "vendor_name", ccsText, "", CCGetRequestParam("vendor_name", ccsGet, NULL), $this);
        $this->vendor_contactperson = new clsControl(ccsLabel, "vendor_contactperson", "vendor_contactperson", ccsText, "", CCGetRequestParam("vendor_contactperson", ccsGet, NULL), $this);
        $this->vendor_phone = new clsControl(ccsLabel, "vendor_phone", "vendor_phone", ccsText, "", CCGetRequestParam("vendor_phone", ccsGet, NULL), $this);
        $this->vendor_address = new clsControl(ccsLabel, "vendor_address", "vendor_address", ccsText, "", CCGetRequestParam("vendor_address", ccsGet, NULL), $this);
        $this->v_id = new clsControl(ccsHidden, "v_id", "v_id", ccsInteger, "", CCGetRequestParam("v_id", ccsGet, NULL), $this);
        $this->s_v_id = new clsControl(ccsLabel, "s_v_id", "s_v_id", ccsInteger, array(True, 0, Null, "", False, array("0", "0", "0", "0", "0", "0"), "", 1, True, ""), CCGetRequestParam("s_v_id", ccsGet, NULL), $this);
        $this->vendor_type_name = new clsControl(ccsLabel, "vendor_type_name", "vendor_type_name", ccsText, "", CCGetRequestParam("vendor_type_name", ccsGet, NULL), $this);
    }
//End Class_Initialize Event

//Initialize Method @5-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @5-C2F30981
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;

        $this->DataSource->Parameters["sescompany_code"] = CCGetSession("company_code", NULL);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["vendor_name"] = $this->vendor_name->Visible;
            $this->ControlsVisible["vendor_contactperson"] = $this->vendor_contactperson->Visible;
            $this->ControlsVisible["vendor_phone"] = $this->vendor_phone->Visible;
            $this->ControlsVisible["vendor_address"] = $this->vendor_address->Visible;
            $this->ControlsVisible["v_id"] = $this->v_id->Visible;
            $this->ControlsVisible["s_v_id"] = $this->s_v_id->Visible;
            $this->ControlsVisible["vendor_type_name"] = $this->vendor_type_name->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->vendor_name->SetValue($this->DataSource->vendor_name->GetValue());
                $this->vendor_contactperson->SetValue($this->DataSource->vendor_contactperson->GetValue());
                $this->vendor_phone->SetValue($this->DataSource->vendor_phone->GetValue());
                $this->vendor_address->SetValue($this->DataSource->vendor_address->GetValue());
                $this->v_id->SetValue($this->DataSource->v_id->GetValue());
                $this->s_v_id->SetValue($this->DataSource->s_v_id->GetValue());
                $this->vendor_type_name->SetValue($this->DataSource->vendor_type_name->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->vendor_name->Show();
                $this->vendor_contactperson->Show();
                $this->vendor_phone->Show();
                $this->vendor_address->Show();
                $this->v_id->Show();
                $this->s_v_id->Show();
                $this->vendor_type_name->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @5-7FF46F7E
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->vendor_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->vendor_contactperson->Errors->ToString());
        $errors = ComposeStrings($errors, $this->vendor_phone->Errors->ToString());
        $errors = ComposeStrings($errors, $this->vendor_address->Errors->ToString());
        $errors = ComposeStrings($errors, $this->v_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->s_v_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->vendor_type_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @5-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @5-E0C69A6C

//DataSource Variables @5-59007949
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $CountSQL;
    public $wp;


    // Datasource fields
    public $vendor_name;
    public $vendor_contactperson;
    public $vendor_phone;
    public $vendor_address;
    public $v_id;
    public $s_v_id;
    public $vendor_type_name;
//End DataSource Variables

//DataSourceClass_Initialize Event @5-3A703ACE
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid clix_list";
        $this->Initialize();
        $this->vendor_name = new clsField("vendor_name", ccsText, "");
        
        $this->vendor_contactperson = new clsField("vendor_contactperson", ccsText, "");
        
        $this->vendor_phone = new clsField("vendor_phone", ccsText, "");
        
        $this->vendor_address = new clsField("vendor_address", ccsText, "");
        
        $this->v_id = new clsField("v_id", ccsInteger, "");
        
        $this->s_v_id = new clsField("s_v_id", ccsInteger, "");
        
        $this->vendor_type_name = new clsField("vendor_type_name", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @5-F3824781
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "mst_vendor_vehicle.vendor_code desc";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @5-3EB62FED
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "sescompany_code", ccsInteger, "", "", $this->Parameters["sescompany_code"], -1, false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "mst_vendor_vehicle.prefix_company_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @5-6D3C59CB
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM mst_vendor_vehicle LEFT JOIN mst_vendor_vehicle_type ON\n\n" .
        "mst_vendor_vehicle.vendor_type_id = mst_vendor_vehicle_type.vendor_type_id";
        $this->SQL = "SELECT prefix_company_code, vendor_code, vendor_name, vendor_address, vendor_contactperson, vendor_phone, vendor_type_name \n\n" .
        "FROM mst_vendor_vehicle LEFT JOIN mst_vendor_vehicle_type ON\n\n" .
        "mst_vendor_vehicle.vendor_type_id = mst_vendor_vehicle_type.vendor_type_id {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @5-5E355617
    function SetValues()
    {
        $this->vendor_name->SetDBValue($this->f("vendor_name"));
        $this->vendor_contactperson->SetDBValue($this->f("vendor_contactperson"));
        $this->vendor_phone->SetDBValue($this->f("vendor_phone"));
        $this->vendor_address->SetDBValue($this->f("vendor_address"));
        $this->v_id->SetDBValue(trim($this->f("vendor_code")));
        $this->s_v_id->SetDBValue(trim($this->f("vendor_code")));
        $this->vendor_type_name->SetDBValue($this->f("vendor_type_name"));
    }
//End SetValues Method

} //End clix_listDataSource Class @5-FCB6E20C

//Initialize Page @1-04ED2DA8
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "mst_vendor_vehicle.html";
$BlockToParse = "main";
$TemplateEncoding = "CP1252";
$ContentType = "text/html";
$PathToRoot = "./";
//End Initialize Page

//Authenticate User @1-2C40F5EA
CCSecurityRedirect("10;3", "");
//End Authenticate User

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-DF20E5AA
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_left_panel = new clsincl_left_panel("", "incl_left_panel", $MainPage);
$incl_left_panel->Initialize();
$incl_header = new clsincl_header("", "incl_header", $MainPage);
$incl_header->Initialize();
$incl_footer = new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$clix_list = new clsGridclix_list("", $MainPage);
$MainPage->incl_left_panel = & $incl_left_panel;
$MainPage->incl_header = & $incl_header;
$MainPage->incl_footer = & $incl_footer;
$MainPage->clix_list = & $clix_list;
$clix_list->Initialize();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-E710DB26
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "CP1252");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-B74CF824
$incl_left_panel->Operations();
$incl_header->Operations();
$incl_footer->Operations();
//End Execute Components

//Go to destination page @1-D092419F
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_left_panel->Class_Terminate();
    unset($incl_left_panel);
    $incl_header->Class_Terminate();
    unset($incl_header);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    unset($clix_list);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-32053747
$incl_left_panel->Show();
$incl_header->Show();
$incl_footer->Show();
$clix_list->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-AEB75043
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_left_panel->Class_Terminate();
unset($incl_left_panel);
$incl_header->Class_Terminate();
unset($incl_header);
$incl_footer->Class_Terminate();
unset($incl_footer);
unset($clix_list);
unset($Tpl);
//End Unload Page


?>
