<?php
//Include Common Files @1-62364430
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "eastern_heavens_contacts.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @3-99BFCBD4
include_once(RelativePath . "/incl_right_panel.php");
//End Include Page implementation

//Include Page implementation @4-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

//Include Page implementation @5-73D590C4
include_once(RelativePath . "/incl_header.php");
//End Include Page implementation

class clsRecordcontent_header { //content_header Class @2-24DA3739

//Variables @2-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @2-77F502C2
    function clsRecordcontent_header($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record content_header/Error";
        $this->DataSource = new clscontent_headerDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "content_header";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->header = new clsControl(ccsLabel, "header", $CCSLocales->GetText("content"), ccsMemo, "", CCGetRequestParam("header", $Method, NULL), $this);
            $this->header->HTML = true;
        }
    }
//End Class_Initialize Event

//Initialize Method @2-5D060BAC
    function Initialize()
    {

        if(!$this->Visible)
            return;

    }
//End Initialize Method

//Validate Method @2-367945B8
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @2-B4850BBF
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->header->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @2-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @2-E33CFFF8
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = true;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @2-B7DF680D
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->header->SetValue($this->DataSource->header->GetValue());
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->header->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->header->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End content_header Class @2-FCB6E20C

class clscontent_headerDataSource extends clsDBConnection1 {  //content_headerDataSource Class @2-B8CD9263

//DataSource Variables @2-5C4DF99A
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $header;
//End DataSource Variables

//DataSourceClass_Initialize Event @2-2CBC7BE2
    function clscontent_headerDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record content_header/Error";
        $this->Initialize();
        $this->header = new clsField("header", ccsMemo, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @2-14D6CD9D
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
    }
//End Prepare Method

//Open Method @2-4045E755
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT content \n\n" .
        "FROM content_header {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @2-B114D5D9
    function SetValues()
    {
        $this->header->SetDBValue($this->f("content"));
    }
//End SetValues Method

} //End content_headerDataSource Class @2-FCB6E20C

class clsRecordcontent { //content Class @17-F9E3F6E4

//Variables @17-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @17-A23B8A55
    function clsRecordcontent($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record content/Error";
        $this->DataSource = new clscontentDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "content";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->content = new clsControl(ccsLabel, "content", $CCSLocales->GetText("content"), ccsMemo, "", CCGetRequestParam("content", $Method, NULL), $this);
            $this->content->HTML = true;
        }
    }
//End Class_Initialize Event

//Initialize Method @17-B6590FB7
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["expr18"] = 7;
    }
//End Initialize Method

//Validate Method @17-367945B8
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @17-E77958AF
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->content->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @17-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @17-17DC9883
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @17-9CEB69E5
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->content->SetValue($this->DataSource->content->GetValue());
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->content->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->content->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End content Class @17-FCB6E20C

class clscontentDataSource extends clsDBConnection1 {  //contentDataSource Class @17-5493A020

//DataSource Variables @17-79FE5E9B
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $content;
//End DataSource Variables

//DataSourceClass_Initialize Event @17-163AA415
    function clscontentDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record content/Error";
        $this->Initialize();
        $this->content = new clsField("content", ccsMemo, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @17-8EEECFB3
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "expr18", ccsInteger, "", "", $this->Parameters["expr18"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "content_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @17-FD14A233
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM content {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @17-C45B9DEC
    function SetValues()
    {
        $this->content->SetDBValue($this->f("content"));
    }
//End SetValues Method

} //End contentDataSource Class @17-FCB6E20C

class clsRecordfeedback { //feedback Class @21-D125E6AA

//Variables @21-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @21-AE8A60BB
    function clsRecordfeedback($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record feedback/Error";
        $this->DataSource = new clsfeedbackDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "feedback";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = new clsButton("Button_Insert", $Method, $this);
            $this->Button_Cancel = new clsButton("Button_Cancel", $Method, $this);
            $this->fname = new clsControl(ccsTextBox, "fname", "First Name", ccsText, "", CCGetRequestParam("fname", $Method, NULL), $this);
            $this->email = new clsControl(ccsTextBox, "email", "Email ID", ccsText, "", CCGetRequestParam("email", $Method, NULL), $this);
            $this->mobile = new clsControl(ccsTextBox, "mobile", "Mobile Phone", ccsText, "", CCGetRequestParam("mobile", $Method, NULL), $this);
            $this->address = new clsControl(ccsTextArea, "address", "Address", ccsText, "", CCGetRequestParam("address", $Method, NULL), $this);
            $this->lname = new clsControl(ccsTextBox, "lname", "Your Name", ccsText, "", CCGetRequestParam("lname", $Method, NULL), $this);
            $this->city = new clsControl(ccsTextBox, "city", "City", ccsText, "", CCGetRequestParam("city", $Method, NULL), $this);
            $this->state = new clsControl(ccsTextBox, "state", "State", ccsText, "", CCGetRequestParam("state", $Method, NULL), $this);
            $this->postcode = new clsControl(ccsTextBox, "postcode", "Post Code", ccsText, "", CCGetRequestParam("postcode", $Method, NULL), $this);
            $this->title = new clsControl(ccsHidden, "title", "Section", ccsText, "", CCGetRequestParam("title", $Method, NULL), $this);
            $this->body = new clsControl(ccsTextArea, "body", "Message", ccsText, "", CCGetRequestParam("body", $Method, NULL), $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @21-5D060BAC
    function Initialize()
    {

        if(!$this->Visible)
            return;

    }
//End Initialize Method

//Validate Method @21-49C09701
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->fname->Validate() && $Validation);
        $Validation = ($this->email->Validate() && $Validation);
        $Validation = ($this->mobile->Validate() && $Validation);
        $Validation = ($this->address->Validate() && $Validation);
        $Validation = ($this->lname->Validate() && $Validation);
        $Validation = ($this->city->Validate() && $Validation);
        $Validation = ($this->state->Validate() && $Validation);
        $Validation = ($this->postcode->Validate() && $Validation);
        $Validation = ($this->title->Validate() && $Validation);
        $Validation = ($this->body->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->fname->Errors->Count() == 0);
        $Validation =  $Validation && ($this->email->Errors->Count() == 0);
        $Validation =  $Validation && ($this->mobile->Errors->Count() == 0);
        $Validation =  $Validation && ($this->address->Errors->Count() == 0);
        $Validation =  $Validation && ($this->lname->Errors->Count() == 0);
        $Validation =  $Validation && ($this->city->Errors->Count() == 0);
        $Validation =  $Validation && ($this->state->Errors->Count() == 0);
        $Validation =  $Validation && ($this->postcode->Errors->Count() == 0);
        $Validation =  $Validation && ($this->title->Errors->Count() == 0);
        $Validation =  $Validation && ($this->body->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @21-3CDAA57C
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->fname->Errors->Count());
        $errors = ($errors || $this->email->Errors->Count());
        $errors = ($errors || $this->mobile->Errors->Count());
        $errors = ($errors || $this->address->Errors->Count());
        $errors = ($errors || $this->lname->Errors->Count());
        $errors = ($errors || $this->city->Errors->Count());
        $errors = ($errors || $this->state->Errors->Count());
        $errors = ($errors || $this->postcode->Errors->Count());
        $errors = ($errors || $this->title->Errors->Count());
        $errors = ($errors || $this->body->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @21-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @21-BC71B1A8
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = true;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Cancel->Pressed) {
                $this->PressedButton = "Button_Cancel";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if($this->PressedButton == "Button_Cancel") {
            if(!CCGetEvent($this->Button_Cancel->CCSEvents, "OnClick", $this->Button_Cancel)) {
                $Redirect = "";
            }
        } else if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                $Redirect = $FileName . "?" . CCMergeQueryStrings(CCGetQueryString("Form", array("Button_Insert", "Button_Insert_x", "Button_Insert_y", "Button_Cancel", "Button_Cancel_x", "Button_Cancel_y")), CCGetQueryString("QueryString", array("fname", "email", "mobile", "address", "lname", "city", "state", "postcode", "title", "body", "ccsForm")));
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert)) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @21-0ACE5618
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
            } else {
                $this->EditMode = false;
            }
        }
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->fname->Errors->ToString());
            $Error = ComposeStrings($Error, $this->email->Errors->ToString());
            $Error = ComposeStrings($Error, $this->mobile->Errors->ToString());
            $Error = ComposeStrings($Error, $this->address->Errors->ToString());
            $Error = ComposeStrings($Error, $this->lname->Errors->ToString());
            $Error = ComposeStrings($Error, $this->city->Errors->ToString());
            $Error = ComposeStrings($Error, $this->state->Errors->ToString());
            $Error = ComposeStrings($Error, $this->postcode->Errors->ToString());
            $Error = ComposeStrings($Error, $this->title->Errors->ToString());
            $Error = ComposeStrings($Error, $this->body->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Cancel->Show();
        $this->fname->Show();
        $this->email->Show();
        $this->mobile->Show();
        $this->address->Show();
        $this->lname->Show();
        $this->city->Show();
        $this->state->Show();
        $this->postcode->Show();
        $this->title->Show();
        $this->body->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End feedback Class @21-FCB6E20C

class clsfeedbackDataSource extends clsDBConnection1 {  //feedbackDataSource Class @21-AD3CD10E

//DataSource Variables @21-38660E8F
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $fname;
    public $email;
    public $mobile;
    public $address;
    public $lname;
    public $city;
    public $state;
    public $postcode;
    public $title;
    public $body;
//End DataSource Variables

//DataSourceClass_Initialize Event @21-690A5EA3
    function clsfeedbackDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record feedback/Error";
        $this->Initialize();
        $this->fname = new clsField("fname", ccsText, "");
        
        $this->email = new clsField("email", ccsText, "");
        
        $this->mobile = new clsField("mobile", ccsText, "");
        
        $this->address = new clsField("address", ccsText, "");
        
        $this->lname = new clsField("lname", ccsText, "");
        
        $this->city = new clsField("city", ccsText, "");
        
        $this->state = new clsField("state", ccsText, "");
        
        $this->postcode = new clsField("postcode", ccsText, "");
        
        $this->title = new clsField("title", ccsText, "");
        
        $this->body = new clsField("body", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @21-14D6CD9D
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
    }
//End Prepare Method

//Open Method @21-7584FC01
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM mst_language {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @21-BAF0975B
    function SetValues()
    {
    }
//End SetValues Method

} //End feedbackDataSource Class @21-FCB6E20C

class clsRecordfeedback_success { //feedback_success Class @40-57C1ECEC

//Variables @40-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @40-D7EB57EB
    function clsRecordfeedback_success($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record feedback_success/Error";
        $this->DataSource = new clsfeedback_successDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "feedback_success";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Cancel = new clsButton("Button_Cancel", $Method, $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @40-5D060BAC
    function Initialize()
    {

        if(!$this->Visible)
            return;

    }
//End Initialize Method

//Validate Method @40-367945B8
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @40-F5A3B433
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @40-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @40-0AE0DCE9
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = true;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = "Button_Cancel";
            if($this->Button_Cancel->Pressed) {
                $this->PressedButton = "Button_Cancel";
            }
        }
        $Redirect = $FileName;
        if($this->PressedButton == "Button_Cancel") {
            if(!CCGetEvent($this->Button_Cancel->CCSEvents, "OnClick", $this->Button_Cancel)) {
                $Redirect = "";
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @40-51F4E83B
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Cancel->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End feedback_success Class @40-FCB6E20C

class clsfeedback_successDataSource extends clsDBConnection1 {  //feedback_successDataSource Class @40-FC04AE54

//DataSource Variables @40-FB4E4A70
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


//End DataSource Variables

//DataSourceClass_Initialize Event @40-C85CBECA
    function clsfeedback_successDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record feedback_success/Error";
        $this->Initialize();

    }
//End DataSourceClass_Initialize Event

//Prepare Method @40-14D6CD9D
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
    }
//End Prepare Method

//Open Method @40-7584FC01
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM mst_language {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @40-BAF0975B
    function SetValues()
    {
    }
//End SetValues Method

} //End feedback_successDataSource Class @40-FCB6E20C

class clsGridtheme_banner1 { //theme_banner1 class @6-2E55758E

//Variables @6-6E51DF5A

    // Public variables
    public $ComponentType = "Grid";
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $ErrorBlock;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $ForceIteration = false;
    public $HasRecord = false;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $RowNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";
    public $Attributes;

    // Grid Controls
    public $StaticControls;
    public $RowControls;
//End Variables

//Class_Initialize Event @6-95DBA6F8
    function clsGridtheme_banner1($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "theme_banner1";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid theme_banner1";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clstheme_banner1DataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 15;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->image_full1 = new clsControl(ccsImage, "image_full1", "image_full1", ccsText, "", CCGetRequestParam("image_full1", ccsGet, NULL), $this);
        $this->caption1 = new clsControl(ccsLabel, "caption1", "caption1", ccsText, "", CCGetRequestParam("caption1", ccsGet, NULL), $this);
        $this->caption2 = new clsControl(ccsLabel, "caption2", "caption2", ccsText, "", CCGetRequestParam("caption2", ccsGet, NULL), $this);
    }
//End Class_Initialize Event

//Initialize Method @6-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @6-94568F7B
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;


        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["image_full1"] = $this->image_full1->Visible;
            $this->ControlsVisible["caption1"] = $this->caption1->Visible;
            $this->ControlsVisible["caption2"] = $this->caption2->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->image_full1->SetValue($this->DataSource->image_full1->GetValue());
                $this->caption1->SetValue($this->DataSource->caption1->GetValue());
                $this->caption2->SetValue($this->DataSource->caption2->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->image_full1->Show();
                $this->caption1->Show();
                $this->caption2->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @6-42DC1E27
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->image_full1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->caption1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->caption2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End theme_banner1 Class @6-FCB6E20C

class clstheme_banner1DataSource extends clsDBConnection1 {  //theme_banner1DataSource Class @6-7E3CDBFE

//DataSource Variables @6-16485007
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $CountSQL;
    public $wp;


    // Datasource fields
    public $image_full1;
    public $caption1;
    public $caption2;
//End DataSource Variables

//DataSourceClass_Initialize Event @6-0B2DDF2F
    function clstheme_banner1DataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid theme_banner1";
        $this->Initialize();
        $this->image_full1 = new clsField("image_full1", ccsText, "");
        
        $this->caption1 = new clsField("caption1", ccsText, "");
        
        $this->caption2 = new clsField("caption2", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @6-E23DEC4A
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "sl";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @6-14D6CD9D
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
    }
//End Prepare Method

//Open Method @6-43BFBE1C
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM theme_banner";
        $this->SQL = "SELECT * \n\n" .
        "FROM theme_banner {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @6-6A05F2DB
    function SetValues()
    {
        $this->image_full1->SetDBValue($this->f("image_full"));
        $this->caption1->SetDBValue($this->f("caption_1"));
        $this->caption2->SetDBValue($this->f("caption_2"));
    }
//End SetValues Method

} //End theme_banner1DataSource Class @6-FCB6E20C

class clsRecordseo { //seo Class @48-D3FFD17E

//Variables @48-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @48-37C4CF9F
    function clsRecordseo($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record seo/Error";
        $this->DataSource = new clsseoDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "seo";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->content = new clsControl(ccsLabel, "content", $CCSLocales->GetText("content"), ccsMemo, "", CCGetRequestParam("content", $Method, NULL), $this);
            $this->content->HTML = true;
            $this->meta_title = new clsControl(ccsHidden, "meta_title", "meta_title", ccsText, "", CCGetRequestParam("meta_title", $Method, NULL), $this);
            $this->meta_desc = new clsControl(ccsHidden, "meta_desc", "meta_desc", ccsText, "", CCGetRequestParam("meta_desc", $Method, NULL), $this);
            $this->meta_keys = new clsControl(ccsHidden, "meta_keys", "meta_keys", ccsText, "", CCGetRequestParam("meta_keys", $Method, NULL), $this);
            $this->site_title = new clsControl(ccsHidden, "site_title", "site_title", ccsText, "", CCGetRequestParam("site_title", $Method, NULL), $this);
            $this->site_desc = new clsControl(ccsHidden, "site_desc", "site_desc", ccsText, "", CCGetRequestParam("site_desc", $Method, NULL), $this);
            $this->site_keys = new clsControl(ccsHidden, "site_keys", "site_keys", ccsText, "", CCGetRequestParam("site_keys", $Method, NULL), $this);
            $this->flg_form = new clsControl(ccsHidden, "flg_form", "flg_form", ccsText, "", CCGetRequestParam("flg_form", $Method, NULL), $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @48-3D290521
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urlcx~"] = CCGetFromGet("cx~", NULL);
    }
//End Initialize Method

//Validate Method @48-41906ECA
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->meta_title->Validate() && $Validation);
        $Validation = ($this->meta_desc->Validate() && $Validation);
        $Validation = ($this->meta_keys->Validate() && $Validation);
        $Validation = ($this->site_title->Validate() && $Validation);
        $Validation = ($this->site_desc->Validate() && $Validation);
        $Validation = ($this->site_keys->Validate() && $Validation);
        $Validation = ($this->flg_form->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->meta_title->Errors->Count() == 0);
        $Validation =  $Validation && ($this->meta_desc->Errors->Count() == 0);
        $Validation =  $Validation && ($this->meta_keys->Errors->Count() == 0);
        $Validation =  $Validation && ($this->site_title->Errors->Count() == 0);
        $Validation =  $Validation && ($this->site_desc->Errors->Count() == 0);
        $Validation =  $Validation && ($this->site_keys->Errors->Count() == 0);
        $Validation =  $Validation && ($this->flg_form->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @48-42CD7018
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->content->Errors->Count());
        $errors = ($errors || $this->meta_title->Errors->Count());
        $errors = ($errors || $this->meta_desc->Errors->Count());
        $errors = ($errors || $this->meta_keys->Errors->Count());
        $errors = ($errors || $this->site_title->Errors->Count());
        $errors = ($errors || $this->site_desc->Errors->Count());
        $errors = ($errors || $this->site_keys->Errors->Count());
        $errors = ($errors || $this->flg_form->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @48-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @48-17DC9883
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @48-F1FDC074
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->content->SetValue($this->DataSource->content->GetValue());
                if(!$this->FormSubmitted){
                    $this->meta_title->SetValue($this->DataSource->meta_title->GetValue());
                    $this->meta_desc->SetValue($this->DataSource->meta_desc->GetValue());
                    $this->meta_keys->SetValue($this->DataSource->meta_keys->GetValue());
                    $this->site_title->SetValue($this->DataSource->site_title->GetValue());
                    $this->site_desc->SetValue($this->DataSource->site_desc->GetValue());
                    $this->site_keys->SetValue($this->DataSource->site_keys->GetValue());
                    $this->flg_form->SetValue($this->DataSource->flg_form->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->content->Errors->ToString());
            $Error = ComposeStrings($Error, $this->meta_title->Errors->ToString());
            $Error = ComposeStrings($Error, $this->meta_desc->Errors->ToString());
            $Error = ComposeStrings($Error, $this->meta_keys->Errors->ToString());
            $Error = ComposeStrings($Error, $this->site_title->Errors->ToString());
            $Error = ComposeStrings($Error, $this->site_desc->Errors->ToString());
            $Error = ComposeStrings($Error, $this->site_keys->Errors->ToString());
            $Error = ComposeStrings($Error, $this->flg_form->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->content->Show();
        $this->meta_title->Show();
        $this->meta_desc->Show();
        $this->meta_keys->Show();
        $this->site_title->Show();
        $this->site_desc->Show();
        $this->site_keys->Show();
        $this->flg_form->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End seo Class @48-FCB6E20C

class clsseoDataSource extends clsDBConnection1 {  //seoDataSource Class @48-702D90F5

//DataSource Variables @48-BBD83D50
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $content;
    public $meta_title;
    public $meta_desc;
    public $meta_keys;
    public $site_title;
    public $site_desc;
    public $site_keys;
    public $flg_form;
//End DataSource Variables

//DataSourceClass_Initialize Event @48-579CA5C3
    function clsseoDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record seo/Error";
        $this->Initialize();
        $this->content = new clsField("content", ccsMemo, "");
        
        $this->meta_title = new clsField("meta_title", ccsText, "");
        
        $this->meta_desc = new clsField("meta_desc", ccsText, "");
        
        $this->meta_keys = new clsField("meta_keys", ccsText, "");
        
        $this->site_title = new clsField("site_title", ccsText, "");
        
        $this->site_desc = new clsField("site_desc", ccsText, "");
        
        $this->site_keys = new clsField("site_keys", ccsText, "");
        
        $this->flg_form = new clsField("flg_form", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @48-FB1345B2
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlcx~", ccsInteger, "", "", $this->Parameters["urlcx~"], 1, false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "content.content_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @48-B32F90E4
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT content, meta_title, meta_desc, meta_keys, site_title, site_desc, site_keys, flg_form \n\n" .
        "FROM mst_language INNER JOIN content ON\n\n" .
        "mst_language.lang_code = content.lang_code {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @48-2CFBDAEA
    function SetValues()
    {
        $this->content->SetDBValue($this->f("content"));
        $this->meta_title->SetDBValue($this->f("meta_title"));
        $this->meta_desc->SetDBValue($this->f("meta_desc"));
        $this->meta_keys->SetDBValue($this->f("meta_keys"));
        $this->site_title->SetDBValue($this->f("site_title"));
        $this->site_desc->SetDBValue($this->f("site_desc"));
        $this->site_keys->SetDBValue($this->f("site_keys"));
        $this->flg_form->SetDBValue($this->f("flg_form"));
    }
//End SetValues Method

} //End seoDataSource Class @48-FCB6E20C





//Initialize Page @1-8B0F3828
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "eastern_heavens_contacts.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "./";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Include events file @1-DD25EA2F
include_once("./eastern_heavens_contacts_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-C4D3753C
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_right_panel = new clsincl_right_panel("", "incl_right_panel", $MainPage);
$incl_right_panel->Initialize();
$incl_footer = new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_header = new clsincl_header("", "incl_header", $MainPage);
$incl_header->Initialize();
$content_header = new clsRecordcontent_header("", $MainPage);
$content = new clsRecordcontent("", $MainPage);
$feedback = new clsRecordfeedback("", $MainPage);
$feedback_success = new clsRecordfeedback_success("", $MainPage);
$theme_banner1 = new clsGridtheme_banner1("", $MainPage);
$seo = new clsRecordseo("", $MainPage);
$MainPage->incl_right_panel = & $incl_right_panel;
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_header = & $incl_header;
$MainPage->content_header = & $content_header;
$MainPage->content = & $content;
$MainPage->feedback = & $feedback;
$MainPage->feedback_success = & $feedback_success;
$MainPage->theme_banner1 = & $theme_banner1;
$MainPage->seo = & $seo;
$content_header->Initialize();
$content->Initialize();
$feedback->Initialize();
$feedback_success->Initialize();
$theme_banner1->Initialize();
$seo->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-51EC165D
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-053205CB
$incl_right_panel->Operations();
$incl_footer->Operations();
$incl_header->Operations();
$content_header->Operation();
$content->Operation();
$feedback->Operation();
$feedback_success->Operation();
$seo->Operation();
//End Execute Components

//Go to destination page @1-5226226A
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_right_panel->Class_Terminate();
    unset($incl_right_panel);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_header->Class_Terminate();
    unset($incl_header);
    unset($content_header);
    unset($content);
    unset($feedback);
    unset($feedback_success);
    unset($theme_banner1);
    unset($seo);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-F7D8F056
$incl_right_panel->Show();
$incl_footer->Show();
$incl_header->Show();
$content_header->Show();
$content->Show();
$feedback->Show();
$feedback_success->Show();
$theme_banner1->Show();
$seo->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-82E5DB29
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_right_panel->Class_Terminate();
unset($incl_right_panel);
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_header->Class_Terminate();
unset($incl_header);
unset($content_header);
unset($content);
unset($feedback);
unset($feedback_success);
unset($theme_banner1);
unset($seo);
unset($Tpl);
//End Unload Page


?>
