<?php
//Include Common Files @1-A611BA27
define("RelativePath", "..");
define("PathToCurrentPage", "/hotel_front/");
define("FileName", "enuiry_cat.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @4-FD074650
include_once(RelativePath . "/hotel_front/incl_footer.php");
//End Include Page implementation

//Include Page implementation @5-980E086F
include_once(RelativePath . "/hotel_front/incl_header.php");
//End Include Page implementation

//Include Page implementation @6-E34603EA
include_once(RelativePath . "/hotel_front/incl_left_panel.php");
//End Include Page implementation



class clsGridscroller { //scroller class @10-DB16AFF4

//Variables @10-6E51DF5A

    // Public variables
    public $ComponentType = "Grid";
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $ErrorBlock;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $ForceIteration = false;
    public $HasRecord = false;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $RowNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";
    public $Attributes;

    // Grid Controls
    public $StaticControls;
    public $RowControls;
//End Variables

//Class_Initialize Event @10-0390EBCB
    function clsGridscroller($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "scroller";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid scroller";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsscrollerDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 10;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->image_full = new clsControl(ccsImage, "image_full", "image_full", ccsText, "", CCGetRequestParam("image_full", ccsGet, NULL), $this);
    }
//End Class_Initialize Event

//Initialize Method @10-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @10-A75C10CE
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;


        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["image_full"] = $this->image_full->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->image_full->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @10-4696349D
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->image_full->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End scroller Class @10-FCB6E20C

class clsscrollerDataSource extends clsDBConnection1 {  //scrollerDataSource Class @10-B26BE4D5

//DataSource Variables @10-DF3DAD77
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $CountSQL;
    public $wp;


    // Datasource fields
    public $image_full;
//End DataSource Variables

//DataSourceClass_Initialize Event @10-49B22704
    function clsscrollerDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid scroller";
        $this->Initialize();
        $this->image_full = new clsField("image_full", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @10-E23DEC4A
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "sl";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @10-14D6CD9D
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
    }
//End Prepare Method

//Open Method @10-8DFD18CB
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM advertisement";
        $this->SQL = "SELECT * \n\n" .
        "FROM advertisement {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @10-17524BE1
    function SetValues()
    {
        $this->image_full->SetDBValue($this->f("image_full"));
    }
//End SetValues Method

} //End scrollerDataSource Class @10-FCB6E20C





class clsRecordw_directory_categories { //w_directory_categories Class @27-F3E2364C

//Variables @27-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @27-6CB64F85
    function clsRecordw_directory_categories($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record w_directory_categories/Error";
        $this->DataSource = new clsw_directory_categoriesDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "w_directory_categories";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->category_name = new clsControl(ccsLabel, "category_name", $CCSLocales->GetText("category_name"), ccsText, "", CCGetRequestParam("category_name", $Method, NULL), $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @27-3D290521
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urlcx~"] = CCGetFromGet("cx~", NULL);
    }
//End Initialize Method

//Validate Method @27-367945B8
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @27-CCBAE381
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->category_name->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @27-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @27-17DC9883
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @27-5B4103F7
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->category_name->SetValue($this->DataSource->category_name->GetValue());
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->category_name->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->category_name->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End w_directory_categories Class @27-FCB6E20C

class clsw_directory_categoriesDataSource extends clsDBConnection1 {  //w_directory_categoriesDataSource Class @27-0DC2DE8B

//DataSource Variables @27-B8D37290
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $category_name;
//End DataSource Variables

//DataSourceClass_Initialize Event @27-AC945C6F
    function clsw_directory_categoriesDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record w_directory_categories/Error";
        $this->Initialize();
        $this->category_name = new clsField("category_name", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @27-9DE10212
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlcx~", ccsInteger, "", "", $this->Parameters["urlcx~"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "category_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @27-305CEA44
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM w_directory_categories {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @27-28E53211
    function SetValues()
    {
        $this->category_name->SetDBValue($this->f("category_name"));
    }
//End SetValues Method

} //End w_directory_categoriesDataSource Class @27-FCB6E20C

class clsRecordcontent { //content Class @22-F9E3F6E4

//Variables @22-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @22-29E5D05C
    function clsRecordcontent($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record content/Error";
        $this->DataSource = new clscontentDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "content";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->content = new clsControl(ccsLabel, "content", "content", ccsMemo, "", CCGetRequestParam("content", $Method, NULL), $this);
            $this->content->HTML = true;
        }
    }
//End Class_Initialize Event

//Initialize Method @22-3D290521
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urlcx~"] = CCGetFromGet("cx~", NULL);
    }
//End Initialize Method

//Validate Method @22-367945B8
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @22-E77958AF
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->content->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @22-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @22-17DC9883
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @22-9CEB69E5
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->content->SetValue($this->DataSource->content->GetValue());
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->content->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->content->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End content Class @22-FCB6E20C

class clscontentDataSource extends clsDBConnection1 {  //contentDataSource Class @22-5493A020

//DataSource Variables @22-79FE5E9B
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $content;
//End DataSource Variables

//DataSourceClass_Initialize Event @22-163AA415
    function clscontentDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record content/Error";
        $this->Initialize();
        $this->content = new clsField("content", ccsMemo, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @22-F4854EF5
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlcx~", ccsInteger, "", "", $this->Parameters["urlcx~"], 1, false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "content_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @22-FD14A233
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM content {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @22-C45B9DEC
    function SetValues()
    {
        $this->content->SetDBValue($this->f("content"));
    }
//End SetValues Method

} //End contentDataSource Class @22-FCB6E20C

class clsEditableGridshopping_cart { //shopping_cart Class @2-87EA2031

//Variables @2-F9538F3C

    // Public variables
    public $ComponentType = "EditableGrid";
    public $ComponentName;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormParameters;
    public $FormState;
    public $FormEnctype;
    public $CachedColumns;
    public $TotalRows;
    public $UpdatedRows;
    public $EmptyRows;
    public $Visible;
    public $RowsErrors;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode;
    public $ValidatingControls;
    public $Controls;
    public $ControlsErrors;
    public $RowNumber;
    public $Attributes;
    public $PrimaryKeys;

    // Class variables
//End Variables

//Class_Initialize Event @2-C900FF00
    function clsEditableGridshopping_cart($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "EditableGrid shopping_cart/Error";
        $this->ControlsErrors = array();
        $this->ComponentName = "shopping_cart";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->CachedColumns["shopping_cart_item_id"][0] = "shopping_cart_item_id";
        $this->CachedColumns["item_id"][0] = "item_id";
        $this->CachedColumns["gr_id"][0] = "gr_id";
        $this->CachedColumns["sys_gr_id"][0] = "sys_gr_id";
        $this->CachedColumns["product_id"][0] = "product_id";
        $this->CachedColumns["cat_id"][0] = "cat_id";
        $this->CachedColumns["store_shopping_cart_items_item_id"][0] = "store_shopping_cart_items_item_id";
        $this->DataSource = new clsshopping_cartDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 100;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: EditableGrid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->EmptyRows = 0;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if(!$this->Visible) return;

        $CCSForm = CCGetFromGet("ccsForm", "");
        $this->FormEnctype = "application/x-www-form-urlencoded";
        $this->FormSubmitted = ($CCSForm == $this->ComponentName);
        if($this->FormSubmitted) {
            $this->FormState = CCGetFromPost("FormState", "");
            $this->SetFormState($this->FormState);
        } else {
            $this->FormState = "";
        }
        $Method = $this->FormSubmitted ? ccsPost : ccsGet;

        $this->image_thumb = new clsControl(ccsImage, "image_thumb", "Image Large", ccsText, "", NULL, $this);
        $this->item_name = new clsControl(ccsLabel, "item_name", "Item Name", ccsText, "", NULL, $this);
        $this->sysgrid = new clsControl(ccsHidden, "sysgrid", "sysgrid", ccsInteger, "", NULL, $this);
        $this->quantity = new clsControl(ccsListBox, "quantity", "Quantity", ccsInteger, "", NULL, $this);
        $this->quantity->DSType = dsListOfValues;
        $this->quantity->Values = array(array("1000", "1000"), array("2000", "2000"), array("5000", "5000"), array("10000", "10000"));
        $this->unit = new clsControl(ccsLabel, "unit", "unit", ccsText, "", NULL, $this);
        $this->unit->HTML = true;
        $this->ImageLink2 = new clsControl(ccsImageLink, "ImageLink2", "ImageLink2", ccsText, "", NULL, $this);
        $this->ImageLink2->Page = "enquiry.php";
        $this->Button1 = new clsButton("Button1", $Method, $this);
        $this->slocation = new clsControl(ccsHidden, "slocation", "slocation", ccsText, "", NULL, $this);
        $this->Button_update = new clsButton("Button_update", $Method, $this);
        $this->Button_update1 = new clsButton("Button_update1", $Method, $this);
    }
//End Class_Initialize Event

//Initialize Method @2-DC1F0616
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);

        $this->DataSource->Parameters["sesjoindia_cart_id"] = CCGetSession("joindia_cart_id", NULL);
    }
//End Initialize Method

//SetPrimaryKeys Method @2-EBC3F86C
    function SetPrimaryKeys($PrimaryKeys) {
        $this->PrimaryKeys = $PrimaryKeys;
        return $this->PrimaryKeys;
    }
//End SetPrimaryKeys Method

//GetPrimaryKeys Method @2-74F9A772
    function GetPrimaryKeys() {
        return $this->PrimaryKeys;
    }
//End GetPrimaryKeys Method

//GetFormParameters Method @2-5A418234
    function GetFormParameters()
    {
        for($RowNumber = 1; $RowNumber <= $this->TotalRows; $RowNumber++)
        {
            $this->FormParameters["sysgrid"][$RowNumber] = CCGetFromPost("sysgrid_" . $RowNumber, NULL);
            $this->FormParameters["quantity"][$RowNumber] = CCGetFromPost("quantity_" . $RowNumber, NULL);
        }
    }
//End GetFormParameters Method

//Validate Method @2-4A6329CE
    function Validate()
    {
        $Validation = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);

        for($this->RowNumber = 1; $this->RowNumber <= $this->TotalRows; $this->RowNumber++)
        {
            $this->DataSource->CachedColumns["shopping_cart_item_id"] = $this->CachedColumns["shopping_cart_item_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["item_id"] = $this->CachedColumns["item_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["gr_id"] = $this->CachedColumns["gr_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["sys_gr_id"] = $this->CachedColumns["sys_gr_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["product_id"] = $this->CachedColumns["product_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["cat_id"] = $this->CachedColumns["cat_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["store_shopping_cart_items_item_id"] = $this->CachedColumns["store_shopping_cart_items_item_id"][$this->RowNumber];
            $this->DataSource->CurrentRow = $this->RowNumber;
            $this->sysgrid->SetText($this->FormParameters["sysgrid"][$this->RowNumber], $this->RowNumber);
            $this->quantity->SetText($this->FormParameters["quantity"][$this->RowNumber], $this->RowNumber);
            if ($this->UpdatedRows >= $this->RowNumber) {
                $Validation = ($this->ValidateRow($this->RowNumber) && $Validation);
            }
            else if($this->CheckInsert())
            {
                $Validation = ($this->ValidateRow() && $Validation);
            }
        }
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//ValidateRow Method @2-C88BEC5F
    function ValidateRow()
    {
        global $CCSLocales;
        $this->sysgrid->Validate();
        $this->quantity->Validate();
        $this->RowErrors = new clsErrors();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidateRow", $this);
        $errors = "";
        $errors = ComposeStrings($errors, $this->sysgrid->Errors->ToString());
        $errors = ComposeStrings($errors, $this->quantity->Errors->ToString());
        $this->sysgrid->Errors->Clear();
        $this->quantity->Errors->Clear();
        $errors = ComposeStrings($errors, $this->RowErrors->ToString());
        $this->RowsErrors[$this->RowNumber] = $errors;
        return $errors != "" ? 0 : 1;
    }
//End ValidateRow Method

//CheckInsert Method @2-0E464156
    function CheckInsert()
    {
        $filed = false;
        $filed = ($filed || (is_array($this->FormParameters["sysgrid"][$this->RowNumber]) && count($this->FormParameters["sysgrid"][$this->RowNumber])) || strlen($this->FormParameters["sysgrid"][$this->RowNumber]));
        $filed = ($filed || (is_array($this->FormParameters["quantity"][$this->RowNumber]) && count($this->FormParameters["quantity"][$this->RowNumber])) || strlen($this->FormParameters["quantity"][$this->RowNumber]));
        return $filed;
    }
//End CheckInsert Method

//CheckErrors Method @2-F5A3B433
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//Operation Method @2-6681C2D6
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted)
            return;

        $this->GetFormParameters();
        $this->PressedButton = "Button1";
        if($this->Button1->Pressed) {
            $this->PressedButton = "Button1";
        } else if($this->Button_update->Pressed) {
            $this->PressedButton = "Button_update";
        } else if($this->Button_update1->Pressed) {
            $this->PressedButton = "Button_update1";
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if($this->PressedButton == "Button1") {
            if(!CCGetEvent($this->Button1->CCSEvents, "OnClick", $this->Button1) || !$this->UpdateGrid()) {
                $Redirect = "";
            } else {
                $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "item_id"));
            }
        } else if($this->PressedButton == "Button_update") {
            if(!CCGetEvent($this->Button_update->CCSEvents, "OnClick", $this->Button_update) || !$this->UpdateGrid()) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "Button_update1") {
            if(!CCGetEvent($this->Button_update1->CCSEvents, "OnClick", $this->Button_update1) || !$this->UpdateGrid()) {
                $Redirect = "";
            } else {
                $Redirect = "checkout.php" . "?" . CCGetQueryString("QueryString", array("ccsForm"));
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//UpdateGrid Method @2-7078B35E
    function UpdateGrid()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSubmit", $this);
        if(!$this->Validate()) return;
        $Validation = true;
        for($this->RowNumber = 1; $this->RowNumber <= $this->TotalRows; $this->RowNumber++)
        {
            $this->DataSource->CachedColumns["shopping_cart_item_id"] = $this->CachedColumns["shopping_cart_item_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["item_id"] = $this->CachedColumns["item_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["gr_id"] = $this->CachedColumns["gr_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["sys_gr_id"] = $this->CachedColumns["sys_gr_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["product_id"] = $this->CachedColumns["product_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["cat_id"] = $this->CachedColumns["cat_id"][$this->RowNumber];
            $this->DataSource->CachedColumns["store_shopping_cart_items_item_id"] = $this->CachedColumns["store_shopping_cart_items_item_id"][$this->RowNumber];
            $this->DataSource->CurrentRow = $this->RowNumber;
            $this->sysgrid->SetText($this->FormParameters["sysgrid"][$this->RowNumber], $this->RowNumber);
            $this->quantity->SetText($this->FormParameters["quantity"][$this->RowNumber], $this->RowNumber);
            if ($this->UpdatedRows >= $this->RowNumber) {
                if($this->UpdateAllowed) { $Validation = ($this->UpdateRow() && $Validation); }
            }
            else if($this->CheckInsert() && $this->InsertAllowed)
            {
                $Validation = ($Validation && $this->InsertRow());
            }
        }
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterSubmit", $this);
        if ($this->Errors->Count() == 0 && $Validation){
            $this->DataSource->close();
            return true;
        }
        return false;
    }
//End UpdateGrid Method

//UpdateRow Method @2-322E61B1
    function UpdateRow()
    {
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->quantity->SetValue($this->quantity->GetValue(true));
        $this->DataSource->Update();
        $errors = "";
        if($this->DataSource->Errors->Count() > 0) {
            $errors = $this->DataSource->Errors->ToString();
            $this->RowsErrors[$this->RowNumber] = $errors;
            $this->DataSource->Errors->Clear();
        }
        return (($this->Errors->Count() == 0) && !strlen($errors));
    }
//End UpdateRow Method

//FormScript Method @2-59800DB5
    function FormScript($TotalRows)
    {
        $script = "";
        return $script;
    }
//End FormScript Method

//SetFormState Method @2-DDACECE7
    function SetFormState($FormState)
    {
        if(strlen($FormState)) {
            $FormState = str_replace("\\\\", "\\" . ord("\\"), $FormState);
            $FormState = str_replace("\\;", "\\" . ord(";"), $FormState);
            $pieces = explode(";", $FormState);
            $this->UpdatedRows = $pieces[0];
            $this->EmptyRows   = $pieces[1];
            $this->TotalRows = $this->UpdatedRows + $this->EmptyRows;
            $RowNumber = 0;
            for($i = 2; $i < sizeof($pieces); $i = $i + 7)  {
                $piece = $pieces[$i + 0];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["shopping_cart_item_id"][$RowNumber] = $piece;
                $piece = $pieces[$i + 1];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["item_id"][$RowNumber] = $piece;
                $piece = $pieces[$i + 2];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["gr_id"][$RowNumber] = $piece;
                $piece = $pieces[$i + 3];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["sys_gr_id"][$RowNumber] = $piece;
                $piece = $pieces[$i + 4];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["product_id"][$RowNumber] = $piece;
                $piece = $pieces[$i + 5];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["cat_id"][$RowNumber] = $piece;
                $piece = $pieces[$i + 6];
                $piece = str_replace("\\" . ord("\\"), "\\", $piece);
                $piece = str_replace("\\" . ord(";"), ";", $piece);
                $this->CachedColumns["store_shopping_cart_items_item_id"][$RowNumber] = $piece;
                $RowNumber++;
            }

            if(!$RowNumber) { $RowNumber = 1; }
            for($i = 1; $i <= $this->EmptyRows; $i++) {
                $this->CachedColumns["shopping_cart_item_id"][$RowNumber] = "";
                $this->CachedColumns["item_id"][$RowNumber] = "";
                $this->CachedColumns["gr_id"][$RowNumber] = "";
                $this->CachedColumns["sys_gr_id"][$RowNumber] = "";
                $this->CachedColumns["product_id"][$RowNumber] = "";
                $this->CachedColumns["cat_id"][$RowNumber] = "";
                $this->CachedColumns["store_shopping_cart_items_item_id"][$RowNumber] = "";
                $RowNumber++;
            }
        }
    }
//End SetFormState Method

//GetFormState Method @2-A2E49404
    function GetFormState($NonEmptyRows)
    {
        if(!$this->FormSubmitted) {
            $this->FormState  = $NonEmptyRows . ";";
            $this->FormState .= $this->InsertAllowed ? $this->EmptyRows : "0";
            if($NonEmptyRows) {
                for($i = 0; $i <= $NonEmptyRows; $i++) {
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["shopping_cart_item_id"][$i]));
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["item_id"][$i]));
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["gr_id"][$i]));
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["sys_gr_id"][$i]));
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["product_id"][$i]));
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["cat_id"][$i]));
                    $this->FormState .= ";" . str_replace(";", "\\;", str_replace("\\", "\\\\", $this->CachedColumns["store_shopping_cart_items_item_id"][$i]));
                }
            }
        }
        return $this->FormState;
    }
//End GetFormState Method

//Show Method @2-2DD68588
    function Show()
    {
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        global $CCSUseAmp;
        $Error = "";

        if(!$this->Visible) { return; }

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->quantity->Prepare();

        $this->DataSource->open();
        $is_next_record = ($this->ReadAllowed && $this->DataSource->next_record());
        $this->IsEmpty = ! $is_next_record;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) { return; }

        $this->Attributes->Show();
        $this->Button1->Visible = $this->Button1->Visible && ($this->InsertAllowed || $this->UpdateAllowed || $this->DeleteAllowed);
        $this->Button_update->Visible = $this->Button_update->Visible && ($this->InsertAllowed || $this->UpdateAllowed || $this->DeleteAllowed);
        $this->Button_update1->Visible = $this->Button_update1->Visible && ($this->InsertAllowed || $this->UpdateAllowed || $this->DeleteAllowed);
        $ParentPath = $Tpl->block_path;
        $EditableGridPath = $ParentPath . "/EditableGrid " . $this->ComponentName;
        $EditableGridRowPath = $ParentPath . "/EditableGrid " . $this->ComponentName . "/Row";
        $Tpl->block_path = $EditableGridRowPath;
        $this->RowNumber = 0;
        $NonEmptyRows = 0;
        $EmptyRowsLeft = $this->EmptyRows;
        $this->ControlsVisible["image_thumb"] = $this->image_thumb->Visible;
        $this->ControlsVisible["item_name"] = $this->item_name->Visible;
        $this->ControlsVisible["sysgrid"] = $this->sysgrid->Visible;
        $this->ControlsVisible["quantity"] = $this->quantity->Visible;
        $this->ControlsVisible["unit"] = $this->unit->Visible;
        $this->ControlsVisible["ImageLink2"] = $this->ImageLink2->Visible;
        if ($is_next_record || ($EmptyRowsLeft && $this->InsertAllowed)) {
            do {
                $this->RowNumber++;
                if($is_next_record) {
                    $NonEmptyRows++;
                    $this->DataSource->SetValues();
                }
                if (!($this->FormSubmitted) && $is_next_record) {
                    $this->CachedColumns["shopping_cart_item_id"][$this->RowNumber] = $this->DataSource->CachedColumns["shopping_cart_item_id"];
                    $this->CachedColumns["item_id"][$this->RowNumber] = $this->DataSource->CachedColumns["item_id"];
                    $this->CachedColumns["gr_id"][$this->RowNumber] = $this->DataSource->CachedColumns["gr_id"];
                    $this->CachedColumns["sys_gr_id"][$this->RowNumber] = $this->DataSource->CachedColumns["sys_gr_id"];
                    $this->CachedColumns["product_id"][$this->RowNumber] = $this->DataSource->CachedColumns["product_id"];
                    $this->CachedColumns["cat_id"][$this->RowNumber] = $this->DataSource->CachedColumns["cat_id"];
                    $this->CachedColumns["store_shopping_cart_items_item_id"][$this->RowNumber] = $this->DataSource->CachedColumns["store_shopping_cart_items_item_id"];
                    $this->ImageLink2->SetText("");
                    $this->image_thumb->SetValue($this->DataSource->image_thumb->GetValue());
                    $this->item_name->SetValue($this->DataSource->item_name->GetValue());
                    $this->sysgrid->SetValue($this->DataSource->sysgrid->GetValue());
                    $this->quantity->SetValue($this->DataSource->quantity->GetValue());
                    $this->unit->SetValue($this->DataSource->unit->GetValue());
                    $this->ImageLink2->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
                    $this->ImageLink2->Parameters = CCAddParam($this->ImageLink2->Parameters, "del_id", $this->DataSource->f("store_shopping_cart_items_item_id"));
                } elseif ($this->FormSubmitted && $is_next_record) {
                    $this->image_thumb->SetText("");
                    $this->item_name->SetText("");
                    $this->unit->SetText("");
                    $this->ImageLink2->SetText("");
                    $this->image_thumb->SetValue($this->DataSource->image_thumb->GetValue());
                    $this->item_name->SetValue($this->DataSource->item_name->GetValue());
                    $this->unit->SetValue($this->DataSource->unit->GetValue());
                    $this->sysgrid->SetText($this->FormParameters["sysgrid"][$this->RowNumber], $this->RowNumber);
                    $this->quantity->SetText($this->FormParameters["quantity"][$this->RowNumber], $this->RowNumber);
                    $this->ImageLink2->Parameters = CCAddParam($this->ImageLink2->Parameters, "del_id", $this->DataSource->f("store_shopping_cart_items_item_id"));
                } elseif (!$this->FormSubmitted) {
                    $this->CachedColumns["shopping_cart_item_id"][$this->RowNumber] = "";
                    $this->CachedColumns["item_id"][$this->RowNumber] = "";
                    $this->CachedColumns["gr_id"][$this->RowNumber] = "";
                    $this->CachedColumns["sys_gr_id"][$this->RowNumber] = "";
                    $this->CachedColumns["product_id"][$this->RowNumber] = "";
                    $this->CachedColumns["cat_id"][$this->RowNumber] = "";
                    $this->CachedColumns["store_shopping_cart_items_item_id"][$this->RowNumber] = "";
                    $this->image_thumb->SetText("");
                    $this->item_name->SetText("");
                    $this->sysgrid->SetText("");
                    $this->quantity->SetText(1000);
                    $this->unit->SetText("");
                    $this->ImageLink2->SetText("");
                    $this->ImageLink2->Parameters = CCAddParam($this->ImageLink2->Parameters, "del_id", $this->DataSource->f("store_shopping_cart_items_item_id"));
                } else {
                    $this->image_thumb->SetText("");
                    $this->item_name->SetText("");
                    $this->unit->SetText("");
                    $this->ImageLink2->SetText("");
                    $this->sysgrid->SetText($this->FormParameters["sysgrid"][$this->RowNumber], $this->RowNumber);
                    $this->quantity->SetText($this->FormParameters["quantity"][$this->RowNumber], $this->RowNumber);
                    $this->ImageLink2->Parameters = CCAddParam($this->ImageLink2->Parameters, "del_id", $this->DataSource->f("store_shopping_cart_items_item_id"));
                }
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->image_thumb->Show($this->RowNumber);
                $this->item_name->Show($this->RowNumber);
                $this->sysgrid->Show($this->RowNumber);
                $this->quantity->Show($this->RowNumber);
                $this->unit->Show($this->RowNumber);
                $this->ImageLink2->Show($this->RowNumber);
                if (isset($this->RowsErrors[$this->RowNumber]) && ($this->RowsErrors[$this->RowNumber] != "")) {
                    $Tpl->setblockvar("RowError", "");
                    $Tpl->setvar("Error", $this->RowsErrors[$this->RowNumber]);
                    $this->Attributes->Show();
                    $Tpl->parse("RowError", false);
                } else {
                    $Tpl->setblockvar("RowError", "");
                }
                $Tpl->setvar("FormScript", $this->FormScript($this->RowNumber));
                $Tpl->parse();
                if ($is_next_record) {
                    if ($this->FormSubmitted) {
                        $is_next_record = $this->RowNumber < $this->UpdatedRows;
                        if (($this->DataSource->CachedColumns["shopping_cart_item_id"] == $this->CachedColumns["shopping_cart_item_id"][$this->RowNumber]) && ($this->DataSource->CachedColumns["item_id"] == $this->CachedColumns["item_id"][$this->RowNumber]) && ($this->DataSource->CachedColumns["gr_id"] == $this->CachedColumns["gr_id"][$this->RowNumber]) && ($this->DataSource->CachedColumns["sys_gr_id"] == $this->CachedColumns["sys_gr_id"][$this->RowNumber]) && ($this->DataSource->CachedColumns["product_id"] == $this->CachedColumns["product_id"][$this->RowNumber]) && ($this->DataSource->CachedColumns["cat_id"] == $this->CachedColumns["cat_id"][$this->RowNumber]) && ($this->DataSource->CachedColumns["store_shopping_cart_items_item_id"] == $this->CachedColumns["store_shopping_cart_items_item_id"][$this->RowNumber])) {
                            if ($this->ReadAllowed) $this->DataSource->next_record();
                        }
                    }else{
                        $is_next_record = ($this->RowNumber < $this->PageSize) &&  $this->ReadAllowed && $this->DataSource->next_record();
                    }
                } else { 
                    $EmptyRowsLeft--;
                }
            } while($is_next_record || ($EmptyRowsLeft && $this->InsertAllowed));
        } else {
            $Tpl->block_path = $EditableGridPath;
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $Tpl->block_path = $EditableGridPath;
        $this->Button1->Show();
        $this->slocation->Show();
        $this->Button_update->Show();
        $this->Button_update1->Show();

        if($this->CheckErrors()) {
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        if (!$CCSUseAmp) {
            $Tpl->SetVar("HTMLFormProperties", "method=\"POST\" action=\"" . $this->HTMLFormAction . "\" name=\"" . $this->ComponentName . "\"");
        } else {
            $Tpl->SetVar("HTMLFormProperties", "method=\"post\" action=\"" . str_replace("&", "&amp;", $this->HTMLFormAction) . "\" id=\"" . $this->ComponentName . "\"");
        }
        $Tpl->SetVar("FormState", CCToHTML($this->GetFormState($NonEmptyRows)));
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End shopping_cart Class @2-FCB6E20C

class clsshopping_cartDataSource extends clsDBConnection1 {  //shopping_cartDataSource Class @2-4B513098

//DataSource Variables @2-E77C90C6
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $UpdateParameters;
    public $CountSQL;
    public $wp;
    public $AllParametersSet;

    public $CachedColumns;
    public $CurrentRow;
    public $UpdateFields = array();

    // Datasource fields
    public $image_thumb;
    public $item_name;
    public $sysgrid;
    public $quantity;
    public $unit;
    public $ImageLink2;
//End DataSource Variables

//DataSourceClass_Initialize Event @2-C52D6D41
    function clsshopping_cartDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "EditableGrid shopping_cart/Error";
        $this->Initialize();
        $this->image_thumb = new clsField("image_thumb", ccsText, "");
        
        $this->item_name = new clsField("item_name", ccsText, "");
        
        $this->sysgrid = new clsField("sysgrid", ccsInteger, "");
        
        $this->quantity = new clsField("quantity", ccsInteger, "");
        
        $this->unit = new clsField("unit", ccsText, "");
        
        $this->ImageLink2 = new clsField("ImageLink2", ccsText, "");
        

        $this->UpdateFields["quantity"] = array("Name" => "quantity", "Value" => "", "DataType" => ccsInteger);
    }
//End DataSourceClass_Initialize Event

//SetOrder Method @2-9E1383D1
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @2-B99E809F
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "sesjoindia_cart_id", ccsInteger, "", "", $this->Parameters["sesjoindia_cart_id"], -1, false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "store_shopping_cart_items.shopping_cart_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @2-682DF2EE
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM (product INNER JOIN store_shopping_cart_items ON\n\n" .
        "store_shopping_cart_items.item_id = product.product_id) INNER JOIN product_category ON\n\n" .
        "product.category_id = product_category.cat_id";
        $this->SQL = "SELECT quantity, store_shopping_cart_items.item_id AS store_shopping_cart_items_item_id, product_name, cat_name, image_thumb \n\n" .
        "FROM (product INNER JOIN store_shopping_cart_items ON\n\n" .
        "store_shopping_cart_items.item_id = product.product_id) INNER JOIN product_category ON\n\n" .
        "product.category_id = product_category.cat_id {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @2-14CD2EF9
    function SetValues()
    {
        $this->CachedColumns["shopping_cart_item_id"] = $this->f("shopping_cart_item_id");
        $this->CachedColumns["item_id"] = $this->f("store_shopping_cart_items_item_id");
        $this->CachedColumns["gr_id"] = $this->f("gr_id");
        $this->CachedColumns["sys_gr_id"] = $this->f("sys_gr_id");
        $this->CachedColumns["product_id"] = $this->f("product_id");
        $this->CachedColumns["cat_id"] = $this->f("cat_id");
        $this->CachedColumns["store_shopping_cart_items_item_id"] = $this->f("store_shopping_cart_items_item_id");
        $this->image_thumb->SetDBValue($this->f("image_thumb"));
        $this->item_name->SetDBValue($this->f("product_name"));
        $this->sysgrid->SetDBValue(trim($this->f("mst_product_gr_system_sys_gr_id")));
        $this->quantity->SetDBValue(trim($this->f("quantity")));
        $this->unit->SetDBValue($this->f("unit"));
    }
//End SetValues Method

//Update Method @2-5CCA5A33
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->cp["quantity"] = new clsSQLParameter("ctrlquantity", ccsInteger, "", "", $this->quantity->GetValue(true), 1000, false, $this->ErrorBlock);
        $wp = new clsSQLParameters($this->ErrorBlock);
        $wp->AddParameter("1", "dsstore_shopping_cart_items_item_id", ccsInteger, "", "", $this->CachedColumns["store_shopping_cart_items_item_id"], "", false);
        if(!$wp->AllParamsSet()) {
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        }
        $wp->AddParameter("2", "sesjoindia_cart_id", ccsInteger, "", "", CCGetSession("joindia_cart_id", NULL), -1, false);
        if(!$wp->AllParamsSet()) {
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        }
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        if (!is_null($this->cp["quantity"]->GetValue()) and !strlen($this->cp["quantity"]->GetText()) and !is_bool($this->cp["quantity"]->GetValue())) 
            $this->cp["quantity"]->SetValue($this->quantity->GetValue(true));
        if (!strlen($this->cp["quantity"]->GetText()) and !is_bool($this->cp["quantity"]->GetValue(true))) 
            $this->cp["quantity"]->SetText(1000);
        $wp->Criterion[1] = $wp->Operation(opEqual, "item_id", $wp->GetDBValue("1"), $this->ToSQL($wp->GetDBValue("1"), ccsInteger),false);
        $wp->Criterion[2] = $wp->Operation(opEqual, "shopping_cart_id", $wp->GetDBValue("2"), $this->ToSQL($wp->GetDBValue("2"), ccsInteger),false);
        $Where = $wp->opAND(
             false, 
             $wp->Criterion[1], 
             $wp->Criterion[2]);
        $this->UpdateFields["quantity"]["Value"] = $this->cp["quantity"]->GetDBValue(true);
        $this->SQL = CCBuildUpdate("store_shopping_cart_items", $this->UpdateFields, $this);
        $this->SQL .= strlen($Where) ? " WHERE " . $Where : $Where;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End shopping_cartDataSource Class @2-FCB6E20C

class clsRecordno_item { //no_item Class @61-4A40120D

//Variables @61-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @61-94E8A084
    function clsRecordno_item($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record no_item/Error";
        $this->DataSource = new clsno_itemDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "no_item";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->slocation_noitem = new clsControl(ccsHidden, "slocation_noitem", "slocation_noitem", ccsText, "", CCGetRequestParam("slocation_noitem", $Method, NULL), $this);
            $this->Button1 = new clsButton("Button1", $Method, $this);
            $this->Button_Update = new clsButton("Button_Update", $Method, $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @61-84571DBA
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urlremark_id"] = CCGetFromGet("remark_id", NULL);
    }
//End Initialize Method

//Validate Method @61-5BBFF90F
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->slocation_noitem->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->slocation_noitem->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @61-B8D32032
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->slocation_noitem->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @61-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @61-24391EEC
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = "Button1";
            if($this->Button1->Pressed) {
                $this->PressedButton = "Button1";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if($this->Validate()) {
            if($this->PressedButton == "Button1") {
                $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "item_id"));
                if(!CCGetEvent($this->Button1->CCSEvents, "OnClick", $this->Button1)) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update)) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @61-1F5F5E13
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
            } else {
                $this->EditMode = false;
            }
        }
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->slocation_noitem->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->slocation_noitem->Show();
        $this->Button1->Show();
        $this->Button_Update->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End no_item Class @61-FCB6E20C

class clsno_itemDataSource extends clsDBConnection1 {  //no_itemDataSource Class @61-F55462BE

//DataSource Variables @61-E4A87293
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $slocation_noitem;
//End DataSource Variables

//DataSourceClass_Initialize Event @61-27C301D2
    function clsno_itemDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record no_item/Error";
        $this->Initialize();
        $this->slocation_noitem = new clsField("slocation_noitem", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @61-5E2E9C61
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlremark_id", ccsInteger, "", "", $this->Parameters["urlremark_id"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "remark_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @61-E813DCB9
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM feedback {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @61-BAF0975B
    function SetValues()
    {
    }
//End SetValues Method

} //End no_itemDataSource Class @61-FCB6E20C









//Initialize Page @1-6215B6DD
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "enuiry_cat.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "../";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Include events file @1-5EAFC4E1
include_once("./enuiry_cat_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-27A62897
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_footer = new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_header = new clsincl_header("", "incl_header", $MainPage);
$incl_header->Initialize();
$incl_left_panel = new clsincl_left_panel("", "incl_left_panel", $MainPage);
$incl_left_panel->Initialize();
$scroller = new clsGridscroller("", $MainPage);
$w_directory_categories = new clsRecordw_directory_categories("", $MainPage);
$content = new clsRecordcontent("", $MainPage);
$shopping_cart = new clsEditableGridshopping_cart("", $MainPage);
$no_item = new clsRecordno_item("", $MainPage);
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_header = & $incl_header;
$MainPage->incl_left_panel = & $incl_left_panel;
$MainPage->scroller = & $scroller;
$MainPage->w_directory_categories = & $w_directory_categories;
$MainPage->content = & $content;
$MainPage->shopping_cart = & $shopping_cart;
$MainPage->no_item = & $no_item;
$scroller->Initialize();
$w_directory_categories->Initialize();
$content->Initialize();
$shopping_cart->Initialize();
$no_item->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-FD7047F5
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8", "replace");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "../");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-8CBC9996
$incl_footer->Operations();
$incl_header->Operations();
$incl_left_panel->Operations();
$w_directory_categories->Operation();
$content->Operation();
$shopping_cart->Operation();
$no_item->Operation();
//End Execute Components

//Go to destination page @1-92F3F06D
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_header->Class_Terminate();
    unset($incl_header);
    $incl_left_panel->Class_Terminate();
    unset($incl_left_panel);
    unset($scroller);
    unset($w_directory_categories);
    unset($content);
    unset($shopping_cart);
    unset($no_item);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-2ECF1001
$incl_footer->Show();
$incl_header->Show();
$incl_left_panel->Show();
$scroller->Show();
$w_directory_categories->Show();
$content->Show();
$shopping_cart->Show();
$no_item->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-6D2AE3AB
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_header->Class_Terminate();
unset($incl_header);
$incl_left_panel->Class_Terminate();
unset($incl_left_panel);
unset($scroller);
unset($w_directory_categories);
unset($content);
unset($shopping_cart);
unset($no_item);
unset($Tpl);
//End Unload Page


?>
