<?php
//Include Common Files @1-6A89315E
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "company.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-DF385382
include_once(RelativePath . "/incl_left_panel.php");
//End Include Page implementation

//Include Page implementation @3-73D590C4
include_once(RelativePath . "/incl_header.php");
//End Include Page implementation

//Include Page implementation @4-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

class clsGridclix_list { //clix_list class @5-9A031AD4

//Variables @5-6E51DF5A

    // Public variables
    public $ComponentType = "Grid";
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $ErrorBlock;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $ForceIteration = false;
    public $HasRecord = false;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $RowNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";
    public $Attributes;

    // Grid Controls
    public $StaticControls;
    public $RowControls;
//End Variables

//Class_Initialize Event @5-49908FE1
    function clsGridclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 500;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 500)
            $this->PageSize = 500;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->company_name = new clsControl(ccsLabel, "company_name", "company_name", ccsText, "", CCGetRequestParam("company_name", ccsGet, NULL), $this);
        $this->my_address = new clsControl(ccsLabel, "my_address", "my_address", ccsText, "", CCGetRequestParam("my_address", ccsGet, NULL), $this);
        $this->my_address->HTML = true;
        $this->city_name = new clsControl(ccsLabel, "city_name", "city_name", ccsText, "", CCGetRequestParam("city_name", ccsGet, NULL), $this);
        $this->state_name = new clsControl(ccsLabel, "state_name", "state_name", ccsText, "", CCGetRequestParam("state_name", ccsGet, NULL), $this);
        $this->country_name = new clsControl(ccsLabel, "country_name", "country_name", ccsText, "", CCGetRequestParam("country_name", ccsGet, NULL), $this);
        $this->company_code = new clsControl(ccsLabel, "company_code", "company_code", ccsInteger, array(True, 0, Null, "", False, array("0", "0", "0", "0", "0", "0"), "", 1, True, ""), CCGetRequestParam("company_code", ccsGet, NULL), $this);
    }
//End Class_Initialize Event

//Initialize Method @5-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @5-4126CF8B
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;


        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["company_name"] = $this->company_name->Visible;
            $this->ControlsVisible["my_address"] = $this->my_address->Visible;
            $this->ControlsVisible["city_name"] = $this->city_name->Visible;
            $this->ControlsVisible["state_name"] = $this->state_name->Visible;
            $this->ControlsVisible["country_name"] = $this->country_name->Visible;
            $this->ControlsVisible["company_code"] = $this->company_code->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->company_name->SetValue($this->DataSource->company_name->GetValue());
                $this->my_address->SetValue($this->DataSource->my_address->GetValue());
                $this->city_name->SetValue($this->DataSource->city_name->GetValue());
                $this->state_name->SetValue($this->DataSource->state_name->GetValue());
                $this->country_name->SetValue($this->DataSource->country_name->GetValue());
                $this->company_code->SetValue($this->DataSource->company_code->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->company_name->Show();
                $this->my_address->Show();
                $this->city_name->Show();
                $this->state_name->Show();
                $this->country_name->Show();
                $this->company_code->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @5-C3B3C4C5
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->company_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->my_address->Errors->ToString());
        $errors = ComposeStrings($errors, $this->city_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->state_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->country_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->company_code->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @5-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @5-E0C69A6C

//DataSource Variables @5-BA0E57DD
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $CountSQL;
    public $wp;


    // Datasource fields
    public $company_name;
    public $my_address;
    public $city_name;
    public $state_name;
    public $country_name;
    public $company_code;
//End DataSource Variables

//DataSourceClass_Initialize Event @5-F2B829F9
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid clix_list";
        $this->Initialize();
        $this->company_name = new clsField("company_name", ccsText, "");
        
        $this->my_address = new clsField("my_address", ccsText, "");
        
        $this->city_name = new clsField("city_name", ccsText, "");
        
        $this->state_name = new clsField("state_name", ccsText, "");
        
        $this->country_name = new clsField("country_name", ccsText, "");
        
        $this->company_code = new clsField("company_code", ccsInteger, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @5-9E1383D1
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @5-14D6CD9D
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
    }
//End Prepare Method

//Open Method @5-6DF5DDD6
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM ((company_mst INNER JOIN city_mst ON\n\n" .
        "company_mst.city_code = city_mst.city_code) INNER JOIN country_mst ON\n\n" .
        "company_mst.country_code = country_mst.country_code) INNER JOIN state_mst ON\n\n" .
        "company_mst.state_code = state_mst.state_code";
        $this->SQL = "SELECT company_code, company_name, city_name, country_name, state_name, concat(company_address_1,if(company_address_2<>'',concat('<br/>',company_address_2),'')) AS my_address \n\n" .
        "FROM ((company_mst INNER JOIN city_mst ON\n\n" .
        "company_mst.city_code = city_mst.city_code) INNER JOIN country_mst ON\n\n" .
        "company_mst.country_code = country_mst.country_code) INNER JOIN state_mst ON\n\n" .
        "company_mst.state_code = state_mst.state_code {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @5-D6B03E7E
    function SetValues()
    {
        $this->company_name->SetDBValue($this->f("company_name"));
        $this->my_address->SetDBValue($this->f("my_address"));
        $this->city_name->SetDBValue($this->f("city_name"));
        $this->state_name->SetDBValue($this->f("state_name"));
        $this->country_name->SetDBValue($this->f("country_name"));
        $this->company_code->SetDBValue(trim($this->f("company_code")));
    }
//End SetValues Method

} //End clix_listDataSource Class @5-FCB6E20C

//Initialize Page @1-0526E16D
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "company.html";
$BlockToParse = "main";
$TemplateEncoding = "CP1252";
$ContentType = "text/html";
$PathToRoot = "./";
//End Initialize Page

//Authenticate User @1-4CBB5244
CCSecurityRedirect("10", "");
//End Authenticate User

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-DF20E5AA
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_left_panel = new clsincl_left_panel("", "incl_left_panel", $MainPage);
$incl_left_panel->Initialize();
$incl_header = new clsincl_header("", "incl_header", $MainPage);
$incl_header->Initialize();
$incl_footer = new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$clix_list = new clsGridclix_list("", $MainPage);
$MainPage->incl_left_panel = & $incl_left_panel;
$MainPage->incl_header = & $incl_header;
$MainPage->incl_footer = & $incl_footer;
$MainPage->clix_list = & $clix_list;
$clix_list->Initialize();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-E710DB26
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "CP1252");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-B74CF824
$incl_left_panel->Operations();
$incl_header->Operations();
$incl_footer->Operations();
//End Execute Components

//Go to destination page @1-D092419F
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_left_panel->Class_Terminate();
    unset($incl_left_panel);
    $incl_header->Class_Terminate();
    unset($incl_header);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    unset($clix_list);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-32053747
$incl_left_panel->Show();
$incl_header->Show();
$incl_footer->Show();
$clix_list->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-AEB75043
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_left_panel->Class_Terminate();
unset($incl_left_panel);
$incl_header->Class_Terminate();
unset($incl_header);
$incl_footer->Class_Terminate();
unset($incl_footer);
unset($clix_list);
unset($Tpl);
//End Unload Page


?>
