<?php
//Include Common Files @1-C56B543A
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "book_showcase.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-1B12872F
include_once(RelativePath . "/incl_ClixTop.php");
//End Include Page implementation



//Include Page implementation @24-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

//Include Page implementation @26-B92CD63A
include_once(RelativePath . "/incl_sidebar.php");
//End Include Page implementation

class clsGridclix_list { //clix_list class @27-9A031AD4

//Variables @27-58BE3784

    // Public variables
    var $ComponentType = "Grid";
    var $ComponentName;
    var $Visible;
    var $Errors;
    var $ErrorBlock;
    var $ds;
    var $DataSource;
    var $PageSize;
    var $IsEmpty;
    var $ForceIteration = false;
    var $HasRecord = false;
    var $SorterName = "";
    var $SorterDirection = "";
    var $PageNumber;
    var $RowNumber;
    var $ControlsVisible = array();

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";
    var $Attributes;

    // Grid Controls
    var $StaticControls;
    var $RowControls;
    var $Sorter_title;
    var $Sorter_sl;
//End Variables

//Class_Initialize Event @27-B250C6CE
    function clsGridclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 40;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;
        $this->SorterName = CCGetParam("clix_listOrder", "");
        $this->SorterDirection = CCGetParam("clix_listDir", "");

        $this->name = & new clsControl(ccsLabel, "name", "name", ccsText, "", CCGetRequestParam("name", ccsGet, NULL), $this);
        $this->ImageLink1 = & new clsControl(ccsImageLink, "ImageLink1", "ImageLink1", ccsText, "", CCGetRequestParam("ImageLink1", ccsGet, NULL), $this);
        $this->ImageLink1->Page = "book_showcase.php";
        $this->ImageLink2 = & new clsControl(ccsImageLink, "ImageLink2", "ImageLink2", ccsText, "", CCGetRequestParam("ImageLink2", ccsGet, NULL), $this);
        $this->ImageLink2->Parameters = CCGetQueryString("QueryString", array("n~", "e~", "ccsForm"));
        $this->ImageLink2->Page = "#";
        $this->cat_id = & new clsControl(ccsHidden, "cat_id", "cat_id", ccsInteger, "", CCGetRequestParam("cat_id", ccsGet, NULL), $this);
        $this->cat_name = & new clsControl(ccsHidden, "cat_name", "cat_name", ccsText, "", CCGetRequestParam("cat_name", ccsGet, NULL), $this);
        $this->image_full = & new clsControl(ccsImageLink, "image_full", "image_full", ccsText, "", CCGetRequestParam("image_full", ccsGet, NULL), $this);
        $this->image_full->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
        $this->sl = & new clsControl(ccsLabel, "sl", "sl", ccsText, "", CCGetRequestParam("sl", ccsGet, NULL), $this);
        $this->top_id = & new clsControl(ccsHidden, "top_id", "top_id", ccsInteger, "", CCGetRequestParam("top_id", ccsGet, NULL), $this);
        $this->product_category_TotalRecords = & new clsControl(ccsLabel, "product_category_TotalRecords", "product_category_TotalRecords", ccsText, "", CCGetRequestParam("product_category_TotalRecords", ccsGet, NULL), $this);
        $this->Sorter_title = & new clsSorter($this->ComponentName, "Sorter_title", $FileName, $this);
        $this->Navigator = & new clsNavigator($this->ComponentName, "Navigator", $FileName, 10, tpSimple, $this);
        $this->Navigator->PageSizes = array("1", "5", "10", "25", "50");
        $this->ImageLink3 = & new clsControl(ccsImageLink, "ImageLink3", "ImageLink3", ccsText, "", CCGetRequestParam("ImageLink3", ccsGet, NULL), $this);
        $this->ImageLink3->Page = "book_showcase.php";
        $this->Sorter_sl = & new clsSorter($this->ComponentName, "Sorter_sl", $FileName, $this);
        $this->caption = & new clsControl(ccsLabel, "caption", "caption", ccsText, "", CCGetRequestParam("caption", ccsGet, NULL), $this);
        $this->caption->HTML = true;
        $this->Link1 = & new clsControl(ccsLink, "Link1", "Link1", ccsText, "", CCGetRequestParam("Link1", ccsGet, NULL), $this);
        $this->Link1->Parameters = CCGetQueryString("QueryString", array("gal", "n~", "E~", "d~", "ccsForm"));
        $this->Link1->Page = "book_category.php";
    }
//End Class_Initialize Event

//Initialize Method @27-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @27-C7F50872
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;

        $this->DataSource->Parameters["urlgal"] = CCGetFromGet("gal", NULL);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["name"] = $this->name->Visible;
            $this->ControlsVisible["ImageLink1"] = $this->ImageLink1->Visible;
            $this->ControlsVisible["ImageLink2"] = $this->ImageLink2->Visible;
            $this->ControlsVisible["cat_id"] = $this->cat_id->Visible;
            $this->ControlsVisible["cat_name"] = $this->cat_name->Visible;
            $this->ControlsVisible["image_full"] = $this->image_full->Visible;
            $this->ControlsVisible["sl"] = $this->sl->Visible;
            $this->ControlsVisible["top_id"] = $this->top_id->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->name->SetValue($this->DataSource->name->GetValue());
                $this->ImageLink1->Parameters = CCGetQueryString("QueryString", array("n~", "d~", "ccsForm"));
                $this->ImageLink1->Parameters = CCAddParam($this->ImageLink1->Parameters, "e~", $this->DataSource->f("content_id"));
                $this->cat_id->SetValue($this->DataSource->cat_id->GetValue());
                $this->cat_name->SetValue($this->DataSource->cat_name->GetValue());
                $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                $this->image_full->Page = $this->DataSource->f("image_full");
                $this->sl->SetValue($this->DataSource->sl->GetValue());
                $this->top_id->SetValue($this->DataSource->top_id->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->name->Show();
                $this->ImageLink1->Show();
                $this->ImageLink2->Show();
                $this->cat_id->Show();
                $this->cat_name->Show();
                $this->image_full->Show();
                $this->sl->Show();
                $this->top_id->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $this->Navigator->PageNumber = $this->DataSource->AbsolutePage;
        $this->Navigator->PageSize = $this->PageSize;
        if ($this->DataSource->RecordsCount == "CCS not counted")
            $this->Navigator->TotalPages = $this->DataSource->AbsolutePage + ($this->DataSource->next_record() ? 1 : 0);
        else
            $this->Navigator->TotalPages = $this->DataSource->PageCount();
        if ($this->Navigator->TotalPages <= 1) {
            $this->Navigator->Visible = false;
        }
        $this->ImageLink3->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "ccsForm"));
        $this->ImageLink3->Parameters = CCAddParam($this->ImageLink3->Parameters, "n~", 1);
        $this->product_category_TotalRecords->Show();
        $this->Sorter_title->Show();
        $this->Navigator->Show();
        $this->ImageLink3->Show();
        $this->Sorter_sl->Show();
        $this->caption->Show();
        $this->Link1->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @27-E741F4D9
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->ImageLink1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->ImageLink2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->image_full->Errors->ToString());
        $errors = ComposeStrings($errors, $this->sl->Errors->ToString());
        $errors = ComposeStrings($errors, $this->top_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @27-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @27-E0C69A6C

//DataSource Variables @27-DEF22684
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $CountSQL;
    var $wp;


    // Datasource fields
    var $name;
    var $cat_id;
    var $cat_name;
    var $image_full;
    var $sl;
    var $top_id;
//End DataSource Variables

//DataSourceClass_Initialize Event @27-6E9F6633
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid clix_list";
        $this->Initialize();
        $this->name = new clsField("name", ccsText, "");
        
        $this->cat_id = new clsField("cat_id", ccsInteger, "");
        
        $this->cat_name = new clsField("cat_name", ccsText, "");
        
        $this->image_full = new clsField("image_full", ccsText, "");
        
        $this->sl = new clsField("sl", ccsText, "");
        
        $this->top_id = new clsField("top_id", ccsInteger, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @27-E5A9C797
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "content_id desc";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            array("Sorter_title" => array("item", ""), 
            "Sorter_sl" => array("sl", "")));
    }
//End SetOrder Method

//Prepare Method @27-41AF94F2
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlgal", ccsInteger, "", "", $this->Parameters["urlgal"], "", false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "ref_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @27-EFF9EDEC
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM book_showcase";
        $this->SQL = "SELECT * \n\n" .
        "FROM book_showcase {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @27-C952CCA8
    function SetValues()
    {
        $this->name->SetDBValue($this->f("item"));
        $this->cat_id->SetDBValue(trim($this->f("content_id")));
        $this->cat_name->SetDBValue($this->f("item"));
        $this->image_full->SetDBValue($this->f("image_full"));
        $this->sl->SetDBValue($this->f("sl"));
        $this->top_id->SetDBValue(trim($this->f("ref_id")));
    }
//End SetValues Method

} //End clix_listDataSource Class @27-FCB6E20C

class clsRecordclix_rec { //clix_rec Class @48-E00062A6

//Variables @48-D6FF3E86

    // Public variables
    var $ComponentType = "Record";
    var $ComponentName;
    var $Parent;
    var $HTMLFormAction;
    var $PressedButton;
    var $Errors;
    var $ErrorBlock;
    var $FormSubmitted;
    var $FormEnctype;
    var $Visible;
    var $IsEmpty;

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";

    var $InsertAllowed = false;
    var $UpdateAllowed = false;
    var $DeleteAllowed = false;
    var $ReadAllowed   = false;
    var $EditMode      = false;
    var $ds;
    var $DataSource;
    var $ValidatingControls;
    var $Controls;
    var $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @48-15CAEAFD
    function clsRecordclix_rec($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->DataSource = new clsclix_recDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "clix_rec";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "multipart/form-data";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = & new clsButton("Button_Insert", $Method, $this);
            $this->Button_Update = & new clsButton("Button_Update", $Method, $this);
            $this->Button_Delete = & new clsButton("Button_Delete", $Method, $this);
            $this->Button_Cancel = & new clsButton("Button_Cancel", $Method, $this);
            $this->item = & new clsControl(ccsTextBox, "item", "Book Name", ccsText, "", CCGetRequestParam("item", $Method, NULL), $this);
            $this->item->Required = true;
            $this->caption1 = & new clsControl(ccsLabel, "caption1", "caption1", ccsText, "", CCGetRequestParam("caption1", $Method, NULL), $this);
            $this->caption1->HTML = true;
            $this->Image2 = & new clsControl(ccsImageLink, "Image2", "Image2", ccsText, "", CCGetRequestParam("Image2", $Method, NULL), $this);
            $this->Image2->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
            $this->image_full = & new clsFileUpload("image_full", "Photo", "../temp_images/", "../clix_images/", "*.gif;*.jpg;*.png", "", 500000, $this);
            $this->image_full->Required = true;
            $this->event_id = & new clsControl(ccsHidden, "event_id", "event_id", ccsInteger, "", CCGetRequestParam("event_id", $Method, NULL), $this);
            $this->sl = & new clsControl(ccsTextBox, "sl", "Serial No#", ccsInteger, "", CCGetRequestParam("sl", $Method, NULL), $this);
            $this->sl->Required = true;
            $this->price = & new clsControl(ccsTextBox, "price", "Category Name", ccsFloat, array(False, 2, Null, Null, False, "", "", 1, True, ""), CCGetRequestParam("price", $Method, NULL), $this);
            $this->net_price = & new clsControl(ccsTextBox, "net_price", "Category Name", ccsFloat, array(False, 2, Null, Null, False, "", "", 1, True, ""), CCGetRequestParam("net_price", $Method, NULL), $this);
            $this->details = & new clsControl(ccsTextArea, "details", "Detail Description", ccsText, "", CCGetRequestParam("details", $Method, NULL), $this);
            $this->details->Required = true;
            $this->meta_title = & new clsControl(ccsTextBox, "meta_title", "Page Title", ccsText, "", CCGetRequestParam("meta_title", $Method, NULL), $this);
            $this->meta_desc = & new clsControl(ccsTextArea, "meta_desc", "Page Description", ccsText, "", CCGetRequestParam("meta_desc", $Method, NULL), $this);
            $this->meta_keys = & new clsControl(ccsTextBox, "meta_keys", "Page Keywords", ccsText, "", CCGetRequestParam("meta_keys", $Method, NULL), $this);
            $this->new_arriaval = & new clsControl(ccsRadioButton, "new_arriaval", "new_arriaval", ccsText, "", CCGetRequestParam("new_arriaval", $Method, NULL), $this);
            $this->new_arriaval->DSType = dsListOfValues;
            $this->new_arriaval->Values = array(array("Y", "Show in New Arrival Section"), array("N", "Hide from New Arrival Section"));
            $this->new_arriaval->HTML = true;
            $this->offer_book = & new clsControl(ccsRadioButton, "offer_book", "offer_book", ccsText, "", CCGetRequestParam("offer_book", $Method, NULL), $this);
            $this->offer_book->DSType = dsListOfValues;
            $this->offer_book->Values = array(array("Y", "Show in Scroller"), array("N", "Hide from Scroller"));
            $this->offer_book->HTML = true;
            $this->home_page = & new clsControl(ccsRadioButton, "home_page", "home_page", ccsText, "", CCGetRequestParam("home_page", $Method, NULL), $this);
            $this->home_page->DSType = dsListOfValues;
            $this->home_page->Values = array(array("Y", "Show on Homepage"), array("N", "Do not Show on Home Page"));
            $this->home_page->HTML = true;
            $this->brief = & new clsControl(ccsTextArea, "brief", "Brief Descriprion", ccsText, "", CCGetRequestParam("brief", $Method, NULL), $this);
            $this->brief->Required = true;
            $this->writer = & new clsControl(ccsTextArea, "writer", "Writer", ccsText, "", CCGetRequestParam("writer", $Method, NULL), $this);
            $this->writer->Required = true;
            $this->isbn = & new clsControl(ccsTextBox, "isbn", "ISBN", ccsText, "", CCGetRequestParam("isbn", $Method, NULL), $this);
            $this->isbn->Required = true;
            if(!$this->FormSubmitted) {
                if(!is_array($this->new_arriaval->Value) && !strlen($this->new_arriaval->Value) && $this->new_arriaval->Value !== false)
                    $this->new_arriaval->SetText("N");
                if(!is_array($this->offer_book->Value) && !strlen($this->offer_book->Value) && $this->offer_book->Value !== false)
                    $this->offer_book->SetText("N");
                if(!is_array($this->home_page->Value) && !strlen($this->home_page->Value) && $this->home_page->Value !== false)
                    $this->home_page->SetText("N");
            }
            if(!is_array($this->caption1->Value) && !strlen($this->caption1->Value) && $this->caption1->Value !== false)
                $this->caption1->SetText('Change Photo');
        }
    }
//End Class_Initialize Event

//Initialize Method @48-354A1FF4
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urle~"] = CCGetFromGet("e~", NULL);
    }
//End Initialize Method

//Validate Method @48-4DF88E93
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->item->Validate() && $Validation);
        $Validation = ($this->image_full->Validate() && $Validation);
        $Validation = ($this->event_id->Validate() && $Validation);
        $Validation = ($this->sl->Validate() && $Validation);
        $Validation = ($this->price->Validate() && $Validation);
        $Validation = ($this->net_price->Validate() && $Validation);
        $Validation = ($this->details->Validate() && $Validation);
        $Validation = ($this->meta_title->Validate() && $Validation);
        $Validation = ($this->meta_desc->Validate() && $Validation);
        $Validation = ($this->meta_keys->Validate() && $Validation);
        $Validation = ($this->new_arriaval->Validate() && $Validation);
        $Validation = ($this->offer_book->Validate() && $Validation);
        $Validation = ($this->home_page->Validate() && $Validation);
        $Validation = ($this->brief->Validate() && $Validation);
        $Validation = ($this->writer->Validate() && $Validation);
        $Validation = ($this->isbn->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->item->Errors->Count() == 0);
        $Validation =  $Validation && ($this->image_full->Errors->Count() == 0);
        $Validation =  $Validation && ($this->event_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->sl->Errors->Count() == 0);
        $Validation =  $Validation && ($this->price->Errors->Count() == 0);
        $Validation =  $Validation && ($this->net_price->Errors->Count() == 0);
        $Validation =  $Validation && ($this->details->Errors->Count() == 0);
        $Validation =  $Validation && ($this->meta_title->Errors->Count() == 0);
        $Validation =  $Validation && ($this->meta_desc->Errors->Count() == 0);
        $Validation =  $Validation && ($this->meta_keys->Errors->Count() == 0);
        $Validation =  $Validation && ($this->new_arriaval->Errors->Count() == 0);
        $Validation =  $Validation && ($this->offer_book->Errors->Count() == 0);
        $Validation =  $Validation && ($this->home_page->Errors->Count() == 0);
        $Validation =  $Validation && ($this->brief->Errors->Count() == 0);
        $Validation =  $Validation && ($this->writer->Errors->Count() == 0);
        $Validation =  $Validation && ($this->isbn->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @48-78522535
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->item->Errors->Count());
        $errors = ($errors || $this->caption1->Errors->Count());
        $errors = ($errors || $this->Image2->Errors->Count());
        $errors = ($errors || $this->image_full->Errors->Count());
        $errors = ($errors || $this->event_id->Errors->Count());
        $errors = ($errors || $this->sl->Errors->Count());
        $errors = ($errors || $this->price->Errors->Count());
        $errors = ($errors || $this->net_price->Errors->Count());
        $errors = ($errors || $this->details->Errors->Count());
        $errors = ($errors || $this->meta_title->Errors->Count());
        $errors = ($errors || $this->meta_desc->Errors->Count());
        $errors = ($errors || $this->meta_keys->Errors->Count());
        $errors = ($errors || $this->new_arriaval->Errors->Count());
        $errors = ($errors || $this->offer_book->Errors->Count());
        $errors = ($errors || $this->home_page->Errors->Count());
        $errors = ($errors || $this->brief->Errors->Count());
        $errors = ($errors || $this->writer->Errors->Count());
        $errors = ($errors || $this->isbn->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @48-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @48-C5D41CF1
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $this->image_full->Upload();

        if($this->FormSubmitted) {
            $this->PressedButton = $this->EditMode ? "Button_Update" : "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            } else if($this->Button_Delete->Pressed) {
                $this->PressedButton = "Button_Delete";
            } else if($this->Button_Cancel->Pressed) {
                $this->PressedButton = "Button_Cancel";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "e~", "d~", "n~"));
        if($this->PressedButton == "Button_Delete") {
            if(!CCGetEvent($this->Button_Delete->CCSEvents, "OnClick", $this->Button_Delete)) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "Button_Cancel") {
            if(!CCGetEvent($this->Button_Cancel->CCSEvents, "OnClick", $this->Button_Cancel)) {
                $Redirect = "";
            }
        } else if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert) || !$this->InsertRow()) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update) || !$this->UpdateRow()) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @48-3F2C9D92
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->item->SetValue($this->item->GetValue(true));
        $this->DataSource->caption1->SetValue($this->caption1->GetValue(true));
        $this->DataSource->Image2->SetValue($this->Image2->GetValue(true));
        $this->DataSource->image_full->SetValue($this->image_full->GetValue(true));
        $this->DataSource->event_id->SetValue($this->event_id->GetValue(true));
        $this->DataSource->sl->SetValue($this->sl->GetValue(true));
        $this->DataSource->price->SetValue($this->price->GetValue(true));
        $this->DataSource->net_price->SetValue($this->net_price->GetValue(true));
        $this->DataSource->details->SetValue($this->details->GetValue(true));
        $this->DataSource->meta_title->SetValue($this->meta_title->GetValue(true));
        $this->DataSource->meta_desc->SetValue($this->meta_desc->GetValue(true));
        $this->DataSource->meta_keys->SetValue($this->meta_keys->GetValue(true));
        $this->DataSource->new_arriaval->SetValue($this->new_arriaval->GetValue(true));
        $this->DataSource->offer_book->SetValue($this->offer_book->GetValue(true));
        $this->DataSource->home_page->SetValue($this->home_page->GetValue(true));
        $this->DataSource->brief->SetValue($this->brief->GetValue(true));
        $this->DataSource->writer->SetValue($this->writer->GetValue(true));
        $this->DataSource->isbn->SetValue($this->isbn->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        if($this->DataSource->Errors->Count() == 0) {
            $this->image_full->Move();
        }
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @48-A121AD0E
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->item->SetValue($this->item->GetValue(true));
        $this->DataSource->caption1->SetValue($this->caption1->GetValue(true));
        $this->DataSource->Image2->SetValue($this->Image2->GetValue(true));
        $this->DataSource->image_full->SetValue($this->image_full->GetValue(true));
        $this->DataSource->event_id->SetValue($this->event_id->GetValue(true));
        $this->DataSource->sl->SetValue($this->sl->GetValue(true));
        $this->DataSource->price->SetValue($this->price->GetValue(true));
        $this->DataSource->net_price->SetValue($this->net_price->GetValue(true));
        $this->DataSource->details->SetValue($this->details->GetValue(true));
        $this->DataSource->meta_title->SetValue($this->meta_title->GetValue(true));
        $this->DataSource->meta_desc->SetValue($this->meta_desc->GetValue(true));
        $this->DataSource->meta_keys->SetValue($this->meta_keys->GetValue(true));
        $this->DataSource->new_arriaval->SetValue($this->new_arriaval->GetValue(true));
        $this->DataSource->offer_book->SetValue($this->offer_book->GetValue(true));
        $this->DataSource->home_page->SetValue($this->home_page->GetValue(true));
        $this->DataSource->brief->SetValue($this->brief->GetValue(true));
        $this->DataSource->writer->SetValue($this->writer->GetValue(true));
        $this->DataSource->isbn->SetValue($this->isbn->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        if($this->DataSource->Errors->Count() == 0) {
            $this->image_full->Move();
        }
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @48-429525F3
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->new_arriaval->Prepare();
        $this->offer_book->Prepare();
        $this->home_page->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->Image2->SetValue($this->DataSource->Image2->GetValue());
                $this->Image2->Page = $this->DataSource->f("image_full");
                if(!$this->FormSubmitted){
                    $this->item->SetValue($this->DataSource->item->GetValue());
                    $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                    $this->event_id->SetValue($this->DataSource->event_id->GetValue());
                    $this->sl->SetValue($this->DataSource->sl->GetValue());
                    $this->price->SetValue($this->DataSource->price->GetValue());
                    $this->net_price->SetValue($this->DataSource->net_price->GetValue());
                    $this->details->SetValue($this->DataSource->details->GetValue());
                    $this->meta_title->SetValue($this->DataSource->meta_title->GetValue());
                    $this->meta_desc->SetValue($this->DataSource->meta_desc->GetValue());
                    $this->meta_keys->SetValue($this->DataSource->meta_keys->GetValue());
                    $this->new_arriaval->SetValue($this->DataSource->new_arriaval->GetValue());
                    $this->offer_book->SetValue($this->DataSource->offer_book->GetValue());
                    $this->home_page->SetValue($this->DataSource->home_page->GetValue());
                    $this->brief->SetValue($this->DataSource->brief->GetValue());
                    $this->writer->SetValue($this->DataSource->writer->GetValue());
                    $this->isbn->SetValue($this->DataSource->isbn->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->item->Errors->ToString());
            $Error = ComposeStrings($Error, $this->caption1->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Image2->Errors->ToString());
            $Error = ComposeStrings($Error, $this->image_full->Errors->ToString());
            $Error = ComposeStrings($Error, $this->event_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->sl->Errors->ToString());
            $Error = ComposeStrings($Error, $this->price->Errors->ToString());
            $Error = ComposeStrings($Error, $this->net_price->Errors->ToString());
            $Error = ComposeStrings($Error, $this->details->Errors->ToString());
            $Error = ComposeStrings($Error, $this->meta_title->Errors->ToString());
            $Error = ComposeStrings($Error, $this->meta_desc->Errors->ToString());
            $Error = ComposeStrings($Error, $this->meta_keys->Errors->ToString());
            $Error = ComposeStrings($Error, $this->new_arriaval->Errors->ToString());
            $Error = ComposeStrings($Error, $this->offer_book->Errors->ToString());
            $Error = ComposeStrings($Error, $this->home_page->Errors->ToString());
            $Error = ComposeStrings($Error, $this->brief->Errors->ToString());
            $Error = ComposeStrings($Error, $this->writer->Errors->ToString());
            $Error = ComposeStrings($Error, $this->isbn->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Insert->Visible = !$this->EditMode && $this->InsertAllowed;
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;
        $this->Button_Delete->Visible = $this->EditMode && $this->DeleteAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Update->Show();
        $this->Button_Delete->Show();
        $this->Button_Cancel->Show();
        $this->item->Show();
        $this->caption1->Show();
        $this->Image2->Show();
        $this->image_full->Show();
        $this->event_id->Show();
        $this->sl->Show();
        $this->price->Show();
        $this->net_price->Show();
        $this->details->Show();
        $this->meta_title->Show();
        $this->meta_desc->Show();
        $this->meta_keys->Show();
        $this->new_arriaval->Show();
        $this->offer_book->Show();
        $this->home_page->Show();
        $this->brief->Show();
        $this->writer->Show();
        $this->isbn->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End clix_rec Class @48-FCB6E20C

class clsclix_recDataSource extends clsDBConnection1 {  //clix_recDataSource Class @48-1EF28E83

//DataSource Variables @48-92D54441
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $InsertParameters;
    var $UpdateParameters;
    var $wp;
    var $AllParametersSet;

    var $InsertFields = array();
    var $UpdateFields = array();

    // Datasource fields
    var $item;
    var $caption1;
    var $Image2;
    var $image_full;
    var $event_id;
    var $sl;
    var $price;
    var $net_price;
    var $details;
    var $meta_title;
    var $meta_desc;
    var $meta_keys;
    var $new_arriaval;
    var $offer_book;
    var $home_page;
    var $brief;
    var $writer;
    var $isbn;
//End DataSource Variables

//DataSourceClass_Initialize Event @48-8FDBF810
    function clsclix_recDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->Initialize();
        $this->item = new clsField("item", ccsText, "");
        
        $this->caption1 = new clsField("caption1", ccsText, "");
        
        $this->Image2 = new clsField("Image2", ccsText, "");
        
        $this->image_full = new clsField("image_full", ccsText, "");
        
        $this->event_id = new clsField("event_id", ccsInteger, "");
        
        $this->sl = new clsField("sl", ccsInteger, "");
        
        $this->price = new clsField("price", ccsFloat, "");
        
        $this->net_price = new clsField("net_price", ccsFloat, "");
        
        $this->details = new clsField("details", ccsText, "");
        
        $this->meta_title = new clsField("meta_title", ccsText, "");
        
        $this->meta_desc = new clsField("meta_desc", ccsText, "");
        
        $this->meta_keys = new clsField("meta_keys", ccsText, "");
        
        $this->new_arriaval = new clsField("new_arriaval", ccsText, "");
        
        $this->offer_book = new clsField("offer_book", ccsText, "");
        
        $this->home_page = new clsField("home_page", ccsText, "");
        
        $this->brief = new clsField("brief", ccsText, "");
        
        $this->writer = new clsField("writer", ccsText, "");
        
        $this->isbn = new clsField("isbn", ccsText, "");
        

        $this->InsertFields["item"] = array("Name" => "item", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["image_full"] = array("Name" => "image_full", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["ref_id"] = array("Name" => "ref_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["sl"] = array("Name" => "sl", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["price"] = array("Name" => "price", "Value" => "", "DataType" => ccsFloat, "OmitIfEmpty" => 1);
        $this->InsertFields["net_price"] = array("Name" => "net_price", "Value" => "", "DataType" => ccsFloat, "OmitIfEmpty" => 1);
        $this->InsertFields["details"] = array("Name" => "details", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["meta_title"] = array("Name" => "meta_title", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["meta_desc"] = array("Name" => "meta_desc", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["meta_keys"] = array("Name" => "meta_keys", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["new_arriaval"] = array("Name" => "new_arriaval", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["scroll_book"] = array("Name" => "scroll_book", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["home_page"] = array("Name" => "home_page", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["brief"] = array("Name" => "brief", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["writer"] = array("Name" => "writer", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["isbn"] = array("Name" => "isbn", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["item"] = array("Name" => "item", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["image_full"] = array("Name" => "image_full", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["ref_id"] = array("Name" => "ref_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["sl"] = array("Name" => "sl", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["price"] = array("Name" => "price", "Value" => "", "DataType" => ccsFloat, "OmitIfEmpty" => 1);
        $this->UpdateFields["net_price"] = array("Name" => "net_price", "Value" => "", "DataType" => ccsFloat, "OmitIfEmpty" => 1);
        $this->UpdateFields["details"] = array("Name" => "details", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["meta_title"] = array("Name" => "meta_title", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["meta_desc"] = array("Name" => "meta_desc", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["meta_keys"] = array("Name" => "meta_keys", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["new_arriaval"] = array("Name" => "new_arriaval", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["scroll_book"] = array("Name" => "scroll_book", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["home_page"] = array("Name" => "home_page", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["brief"] = array("Name" => "brief", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["writer"] = array("Name" => "writer", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["isbn"] = array("Name" => "isbn", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @48-1544C04C
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urle~", ccsInteger, "", "", $this->Parameters["urle~"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "content_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @48-0F2B266A
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM book_showcase {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @48-953B7096
    function SetValues()
    {
        $this->item->SetDBValue($this->f("item"));
        $this->Image2->SetDBValue($this->f("image_full"));
        $this->image_full->SetDBValue($this->f("image_full"));
        $this->event_id->SetDBValue(trim($this->f("ref_id")));
        $this->sl->SetDBValue(trim($this->f("sl")));
        $this->price->SetDBValue(trim($this->f("price")));
        $this->net_price->SetDBValue(trim($this->f("net_price")));
        $this->details->SetDBValue($this->f("details"));
        $this->meta_title->SetDBValue($this->f("meta_title"));
        $this->meta_desc->SetDBValue($this->f("meta_desc"));
        $this->meta_keys->SetDBValue($this->f("meta_keys"));
        $this->new_arriaval->SetDBValue($this->f("new_arriaval"));
        $this->offer_book->SetDBValue($this->f("scroll_book"));
        $this->home_page->SetDBValue($this->f("home_page"));
        $this->brief->SetDBValue($this->f("brief"));
        $this->writer->SetDBValue($this->f("writer"));
        $this->isbn->SetDBValue($this->f("isbn"));
    }
//End SetValues Method

//Insert Method @48-C01A8F4F
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        $this->InsertFields["item"]["Value"] = $this->item->GetDBValue(true);
        $this->InsertFields["image_full"]["Value"] = $this->image_full->GetDBValue(true);
        $this->InsertFields["ref_id"]["Value"] = $this->event_id->GetDBValue(true);
        $this->InsertFields["sl"]["Value"] = $this->sl->GetDBValue(true);
        $this->InsertFields["price"]["Value"] = $this->price->GetDBValue(true);
        $this->InsertFields["net_price"]["Value"] = $this->net_price->GetDBValue(true);
        $this->InsertFields["details"]["Value"] = $this->details->GetDBValue(true);
        $this->InsertFields["meta_title"]["Value"] = $this->meta_title->GetDBValue(true);
        $this->InsertFields["meta_desc"]["Value"] = $this->meta_desc->GetDBValue(true);
        $this->InsertFields["meta_keys"]["Value"] = $this->meta_keys->GetDBValue(true);
        $this->InsertFields["new_arriaval"]["Value"] = $this->new_arriaval->GetDBValue(true);
        $this->InsertFields["scroll_book"]["Value"] = $this->offer_book->GetDBValue(true);
        $this->InsertFields["home_page"]["Value"] = $this->home_page->GetDBValue(true);
        $this->InsertFields["brief"]["Value"] = $this->brief->GetDBValue(true);
        $this->InsertFields["writer"]["Value"] = $this->writer->GetDBValue(true);
        $this->InsertFields["isbn"]["Value"] = $this->isbn->GetDBValue(true);
        $this->SQL = CCBuildInsert("book_showcase", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @48-53AA827B
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["item"]["Value"] = $this->item->GetDBValue(true);
        $this->UpdateFields["image_full"]["Value"] = $this->image_full->GetDBValue(true);
        $this->UpdateFields["ref_id"]["Value"] = $this->event_id->GetDBValue(true);
        $this->UpdateFields["sl"]["Value"] = $this->sl->GetDBValue(true);
        $this->UpdateFields["price"]["Value"] = $this->price->GetDBValue(true);
        $this->UpdateFields["net_price"]["Value"] = $this->net_price->GetDBValue(true);
        $this->UpdateFields["details"]["Value"] = $this->details->GetDBValue(true);
        $this->UpdateFields["meta_title"]["Value"] = $this->meta_title->GetDBValue(true);
        $this->UpdateFields["meta_desc"]["Value"] = $this->meta_desc->GetDBValue(true);
        $this->UpdateFields["meta_keys"]["Value"] = $this->meta_keys->GetDBValue(true);
        $this->UpdateFields["new_arriaval"]["Value"] = $this->new_arriaval->GetDBValue(true);
        $this->UpdateFields["scroll_book"]["Value"] = $this->offer_book->GetDBValue(true);
        $this->UpdateFields["home_page"]["Value"] = $this->home_page->GetDBValue(true);
        $this->UpdateFields["brief"]["Value"] = $this->brief->GetDBValue(true);
        $this->UpdateFields["writer"]["Value"] = $this->writer->GetDBValue(true);
        $this->UpdateFields["isbn"]["Value"] = $this->isbn->GetDBValue(true);
        $this->SQL = CCBuildUpdate("book_showcase", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End clix_recDataSource Class @48-FCB6E20C











//Initialize Page @1-F5FAB3C8
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "book_showcase.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "./";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Authenticate User @1-74BBAD6F
CCSecurityRedirect("6666", "");
//End Authenticate User

//Include events file @1-049F3A6C
include_once("./book_showcase_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-5B0637B3
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_ClixTop = & new clsincl_ClixTop("", "incl_ClixTop", $MainPage);
$incl_ClixTop->Initialize();
$incl_footer = & new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_sidebar = & new clsincl_sidebar("", "incl_sidebar", $MainPage);
$incl_sidebar->Initialize();
$clix_list = & new clsGridclix_list("", $MainPage);
$clix_rec = & new clsRecordclix_rec("", $MainPage);
$MainPage->incl_ClixTop = & $incl_ClixTop;
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_sidebar = & $incl_sidebar;
$MainPage->clix_list = & $clix_list;
$MainPage->clix_rec = & $clix_rec;
$clix_list->Initialize();
$clix_rec->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-51EC165D
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-F0606FE4
$incl_ClixTop->Operations();
$incl_footer->Operations();
$incl_sidebar->Operations();
$clix_rec->Operation();
//End Execute Components

//Go to destination page @1-788A201D
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_ClixTop->Class_Terminate();
    unset($incl_ClixTop);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_sidebar->Class_Terminate();
    unset($incl_sidebar);
    unset($clix_list);
    unset($clix_rec);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-A7A75B9D
$incl_ClixTop->Show();
$incl_footer->Show();
$incl_sidebar->Show();
$clix_list->Show();
$clix_rec->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-F854B87C
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_ClixTop->Class_Terminate();
unset($incl_ClixTop);
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_sidebar->Class_Terminate();
unset($incl_sidebar);
unset($clix_list);
unset($clix_rec);
unset($Tpl);
//End Unload Page


?>
