<?php
//Include Common Files @1-4EE30E5F
define("RelativePath", "..");
define("PathToCurrentPage", "/hotel_front/");
define("FileName", "catalogue_n.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @4-FD074650
include_once(RelativePath . "/hotel_front/incl_footer.php");
//End Include Page implementation

//Include Page implementation @5-980E086F
include_once(RelativePath . "/hotel_front/incl_header.php");
//End Include Page implementation

//Include Page implementation @6-E34603EA
include_once(RelativePath . "/hotel_front/incl_left_panel.php");
//End Include Page implementation

class clsGridbook_showcase { //book_showcase class @14-9901D02F

//Variables @14-6E51DF5A

    // Public variables
    public $ComponentType = "Grid";
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $ErrorBlock;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $ForceIteration = false;
    public $HasRecord = false;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $RowNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";
    public $Attributes;

    // Grid Controls
    public $StaticControls;
    public $RowControls;
//End Variables

//Class_Initialize Event @14-9302BBB8
    function clsGridbook_showcase($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "book_showcase";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid book_showcase";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsbook_showcaseDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 8;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->image_full = new clsControl(ccsImageLink, "image_full", "image_full", ccsText, "", CCGetRequestParam("image_full", ccsGet, NULL), $this);
        $this->image_full->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
        $this->image_full->Page = "";
        $this->caption_1 = new clsControl(ccsLabel, "caption_1", "caption_1", ccsText, "", CCGetRequestParam("caption_1", ccsGet, NULL), $this);
        $this->price = new clsControl(ccsLabel, "price", "price", ccsFloat, "", CCGetRequestParam("price", ccsGet, NULL), $this);
        $this->net_price = new clsControl(ccsLabel, "net_price", "net_price", ccsFloat, "", CCGetRequestParam("net_price", ccsGet, NULL), $this);
        $this->Navigator = new clsNavigator($this->ComponentName, "Navigator", $FileName, 10, tpCentered, $this);
        $this->Navigator->PageSizes = array("1", "5", "10", "25", "50");
    }
//End Class_Initialize Event

//Initialize Method @14-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @14-C12308AA
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;

        $this->DataSource->Parameters["expr26"] = Y;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["image_full"] = $this->image_full->Visible;
            $this->ControlsVisible["caption_1"] = $this->caption_1->Visible;
            $this->ControlsVisible["price"] = $this->price->Visible;
            $this->ControlsVisible["net_price"] = $this->net_price->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                $this->caption_1->SetValue($this->DataSource->caption_1->GetValue());
                $this->price->SetValue($this->DataSource->price->GetValue());
                $this->net_price->SetValue($this->DataSource->net_price->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->image_full->Show();
                $this->caption_1->Show();
                $this->price->Show();
                $this->net_price->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $this->Navigator->PageNumber = $this->DataSource->AbsolutePage;
        $this->Navigator->PageSize = $this->PageSize;
        if ($this->DataSource->RecordsCount == "CCS not counted")
            $this->Navigator->TotalPages = $this->DataSource->AbsolutePage + ($this->DataSource->next_record() ? 1 : 0);
        else
            $this->Navigator->TotalPages = $this->DataSource->PageCount();
        if ($this->Navigator->TotalPages <= 1) {
            $this->Navigator->Visible = false;
        }
        $this->Navigator->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @14-6CC18414
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->image_full->Errors->ToString());
        $errors = ComposeStrings($errors, $this->caption_1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->price->Errors->ToString());
        $errors = ComposeStrings($errors, $this->net_price->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End book_showcase Class @14-FCB6E20C

class clsbook_showcaseDataSource extends clsDBConnection1 {  //book_showcaseDataSource Class @14-C781EADD

//DataSource Variables @14-82FA3E4D
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $CountSQL;
    public $wp;


    // Datasource fields
    public $image_full;
    public $caption_1;
    public $price;
    public $net_price;
//End DataSource Variables

//DataSourceClass_Initialize Event @14-66226859
    function clsbook_showcaseDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid book_showcase";
        $this->Initialize();
        $this->image_full = new clsField("image_full", ccsText, "");
        
        $this->caption_1 = new clsField("caption_1", ccsText, "");
        
        $this->price = new clsField("price", ccsFloat, "");
        
        $this->net_price = new clsField("net_price", ccsFloat, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @14-E23DEC4A
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "sl";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @14-CF1CF6B2
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "expr26", ccsText, "", "", $this->Parameters["expr26"], "", false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "new_arriaval", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsText),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @14-EFF9EDEC
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM book_showcase";
        $this->SQL = "SELECT * \n\n" .
        "FROM book_showcase {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @14-227AF881
    function SetValues()
    {
        $this->image_full->SetDBValue($this->f("image_full"));
        $this->caption_1->SetDBValue($this->f("caption_1"));
        $this->price->SetDBValue(trim($this->f("price")));
        $this->net_price->SetDBValue(trim($this->f("net_price")));
    }
//End SetValues Method

} //End book_showcaseDataSource Class @14-FCB6E20C

class clsRecordcontent { //content Class @22-F9E3F6E4

//Variables @22-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @22-29E5D05C
    function clsRecordcontent($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record content/Error";
        $this->DataSource = new clscontentDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "content";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->content = new clsControl(ccsLabel, "content", "content", ccsMemo, "", CCGetRequestParam("content", $Method, NULL), $this);
            $this->content->HTML = true;
        }
    }
//End Class_Initialize Event

//Initialize Method @22-3D290521
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urlcx~"] = CCGetFromGet("cx~", NULL);
    }
//End Initialize Method

//Validate Method @22-367945B8
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @22-E77958AF
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->content->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @22-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @22-17DC9883
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @22-9CEB69E5
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->content->SetValue($this->DataSource->content->GetValue());
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->content->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->content->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End content Class @22-FCB6E20C

class clscontentDataSource extends clsDBConnection1 {  //contentDataSource Class @22-5493A020

//DataSource Variables @22-79FE5E9B
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $content;
//End DataSource Variables

//DataSourceClass_Initialize Event @22-163AA415
    function clscontentDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record content/Error";
        $this->Initialize();
        $this->content = new clsField("content", ccsMemo, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @22-F4854EF5
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlcx~", ccsInteger, "", "", $this->Parameters["urlcx~"], 1, false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "content_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @22-FD14A233
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM content {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @22-C45B9DEC
    function SetValues()
    {
        $this->content->SetDBValue($this->f("content"));
    }
//End SetValues Method

} //End contentDataSource Class @22-FCB6E20C



class clsGridscroller { //scroller class @10-DB16AFF4

//Variables @10-6E51DF5A

    // Public variables
    public $ComponentType = "Grid";
    public $ComponentName;
    public $Visible;
    public $Errors;
    public $ErrorBlock;
    public $ds;
    public $DataSource;
    public $PageSize;
    public $IsEmpty;
    public $ForceIteration = false;
    public $HasRecord = false;
    public $SorterName = "";
    public $SorterDirection = "";
    public $PageNumber;
    public $RowNumber;
    public $ControlsVisible = array();

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";
    public $Attributes;

    // Grid Controls
    public $StaticControls;
    public $RowControls;
//End Variables

//Class_Initialize Event @10-ED51B331
    function clsGridscroller($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "scroller";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid scroller";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsscrollerDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 10;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;

        $this->image_full = new clsControl(ccsImageLink, "image_full", "image_full", ccsText, "", CCGetRequestParam("image_full", ccsGet, NULL), $this);
        $this->image_full->Page = "enquiry_cat.php";
    }
//End Class_Initialize Event

//Initialize Method @10-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @10-AAC5BAC4
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;

        $this->DataSource->Parameters["expr28"] = Y;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["image_full"] = $this->image_full->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                $this->image_full->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
                $this->image_full->Parameters = CCAddParam($this->image_full->Parameters, "item_id", $this->DataSource->f("content_id"));
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->image_full->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @10-4696349D
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->image_full->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End scroller Class @10-FCB6E20C

class clsscrollerDataSource extends clsDBConnection1 {  //scrollerDataSource Class @10-B26BE4D5

//DataSource Variables @10-DF3DAD77
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $CountSQL;
    public $wp;


    // Datasource fields
    public $image_full;
//End DataSource Variables

//DataSourceClass_Initialize Event @10-49B22704
    function clsscrollerDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid scroller";
        $this->Initialize();
        $this->image_full = new clsField("image_full", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @10-E23DEC4A
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "sl";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @10-DB882D74
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "expr28", ccsText, "", "", $this->Parameters["expr28"], "", false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "scroll_book", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsText),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @10-EFF9EDEC
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM book_showcase";
        $this->SQL = "SELECT * \n\n" .
        "FROM book_showcase {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @10-17524BE1
    function SetValues()
    {
        $this->image_full->SetDBValue($this->f("image_full"));
    }
//End SetValues Method

} //End scrollerDataSource Class @10-FCB6E20C

class clsRecordmeta_tag { //meta_tag Class @30-53533E46

//Variables @30-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @30-F1758CAF
    function clsRecordmeta_tag($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record meta_tag/Error";
        $this->DataSource = new clsmeta_tagDataSource($this);
        $this->ds = & $this->DataSource;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "meta_tag";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->meta_title = new clsControl(ccsHidden, "meta_title", "meta_title", ccsText, "", CCGetRequestParam("meta_title", $Method, NULL), $this);
            $this->meta_desc = new clsControl(ccsHidden, "meta_desc", "meta_desc", ccsText, "", CCGetRequestParam("meta_desc", $Method, NULL), $this);
            $this->meta_keys = new clsControl(ccsHidden, "meta_keys", "meta_keys", ccsText, "", CCGetRequestParam("meta_keys", $Method, NULL), $this);
            $this->site_title = new clsControl(ccsHidden, "site_title", "site_title", ccsText, "", CCGetRequestParam("site_title", $Method, NULL), $this);
            $this->site_desc = new clsControl(ccsHidden, "site_desc", "site_desc", ccsText, "", CCGetRequestParam("site_desc", $Method, NULL), $this);
            $this->site_keys = new clsControl(ccsHidden, "site_keys", "site_keys", ccsText, "", CCGetRequestParam("site_keys", $Method, NULL), $this);
            $this->flg_form = new clsControl(ccsHidden, "flg_form", "flg_form", ccsText, "", CCGetRequestParam("flg_form", $Method, NULL), $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @30-3D290521
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urlcx~"] = CCGetFromGet("cx~", NULL);
    }
//End Initialize Method

//Validate Method @30-41906ECA
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->meta_title->Validate() && $Validation);
        $Validation = ($this->meta_desc->Validate() && $Validation);
        $Validation = ($this->meta_keys->Validate() && $Validation);
        $Validation = ($this->site_title->Validate() && $Validation);
        $Validation = ($this->site_desc->Validate() && $Validation);
        $Validation = ($this->site_keys->Validate() && $Validation);
        $Validation = ($this->flg_form->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->meta_title->Errors->Count() == 0);
        $Validation =  $Validation && ($this->meta_desc->Errors->Count() == 0);
        $Validation =  $Validation && ($this->meta_keys->Errors->Count() == 0);
        $Validation =  $Validation && ($this->site_title->Errors->Count() == 0);
        $Validation =  $Validation && ($this->site_desc->Errors->Count() == 0);
        $Validation =  $Validation && ($this->site_keys->Errors->Count() == 0);
        $Validation =  $Validation && ($this->flg_form->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @30-D1A913FF
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->meta_title->Errors->Count());
        $errors = ($errors || $this->meta_desc->Errors->Count());
        $errors = ($errors || $this->meta_keys->Errors->Count());
        $errors = ($errors || $this->site_title->Errors->Count());
        $errors = ($errors || $this->site_desc->Errors->Count());
        $errors = ($errors || $this->site_keys->Errors->Count());
        $errors = ($errors || $this->flg_form->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @30-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @30-17DC9883
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//Show Method @30-D38655EB
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                if(!$this->FormSubmitted){
                    $this->meta_title->SetValue($this->DataSource->meta_title->GetValue());
                    $this->meta_desc->SetValue($this->DataSource->meta_desc->GetValue());
                    $this->meta_keys->SetValue($this->DataSource->meta_keys->GetValue());
                    $this->site_title->SetValue($this->DataSource->site_title->GetValue());
                    $this->site_desc->SetValue($this->DataSource->site_desc->GetValue());
                    $this->site_keys->SetValue($this->DataSource->site_keys->GetValue());
                    $this->flg_form->SetValue($this->DataSource->flg_form->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->meta_title->Errors->ToString());
            $Error = ComposeStrings($Error, $this->meta_desc->Errors->ToString());
            $Error = ComposeStrings($Error, $this->meta_keys->Errors->ToString());
            $Error = ComposeStrings($Error, $this->site_title->Errors->ToString());
            $Error = ComposeStrings($Error, $this->site_desc->Errors->ToString());
            $Error = ComposeStrings($Error, $this->site_keys->Errors->ToString());
            $Error = ComposeStrings($Error, $this->flg_form->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->meta_title->Show();
        $this->meta_desc->Show();
        $this->meta_keys->Show();
        $this->site_title->Show();
        $this->site_desc->Show();
        $this->site_keys->Show();
        $this->flg_form->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End meta_tag Class @30-FCB6E20C

class clsmeta_tagDataSource extends clsDBConnection1 {  //meta_tagDataSource Class @30-33CC7527

//DataSource Variables @30-BF3AF109
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $wp;
    public $AllParametersSet;


    // Datasource fields
    public $meta_title;
    public $meta_desc;
    public $meta_keys;
    public $site_title;
    public $site_desc;
    public $site_keys;
    public $flg_form;
//End DataSource Variables

//DataSourceClass_Initialize Event @30-17BE4891
    function clsmeta_tagDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record meta_tag/Error";
        $this->Initialize();
        $this->meta_title = new clsField("meta_title", ccsText, "");
        
        $this->meta_desc = new clsField("meta_desc", ccsText, "");
        
        $this->meta_keys = new clsField("meta_keys", ccsText, "");
        
        $this->site_title = new clsField("site_title", ccsText, "");
        
        $this->site_desc = new clsField("site_desc", ccsText, "");
        
        $this->site_keys = new clsField("site_keys", ccsText, "");
        
        $this->flg_form = new clsField("flg_form", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//Prepare Method @30-93573176
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urlcx~", ccsInteger, "", "", $this->Parameters["urlcx~"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "content_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @30-0F2B266A
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM book_showcase {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @30-AAF5B5A1
    function SetValues()
    {
        $this->meta_title->SetDBValue($this->f("meta_title"));
        $this->meta_desc->SetDBValue($this->f("meta_desc"));
        $this->meta_keys->SetDBValue($this->f("meta_keys"));
        $this->site_title->SetDBValue($this->f("site_title"));
        $this->site_desc->SetDBValue($this->f("site_desc"));
        $this->site_keys->SetDBValue($this->f("site_keys"));
        $this->flg_form->SetDBValue($this->f("flg_form"));
    }
//End SetValues Method

} //End meta_tagDataSource Class @30-FCB6E20C











//Initialize Page @1-2A8AE525
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "catalogue_n.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "../";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Include events file @1-DE7DA56C
include_once("./catalogue_n_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-42CBD288
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_footer = new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_header = new clsincl_header("", "incl_header", $MainPage);
$incl_header->Initialize();
$incl_left_panel = new clsincl_left_panel("", "incl_left_panel", $MainPage);
$incl_left_panel->Initialize();
$book_showcase = new clsGridbook_showcase("", $MainPage);
$content = new clsRecordcontent("", $MainPage);
$scroller = new clsGridscroller("", $MainPage);
$meta_tag = new clsRecordmeta_tag("", $MainPage);
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_header = & $incl_header;
$MainPage->incl_left_panel = & $incl_left_panel;
$MainPage->book_showcase = & $book_showcase;
$MainPage->content = & $content;
$MainPage->scroller = & $scroller;
$MainPage->meta_tag = & $meta_tag;
$book_showcase->Initialize();
$content->Initialize();
$scroller->Initialize();
$meta_tag->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-FD7047F5
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8", "replace");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "../");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-E1F3C4D9
$incl_footer->Operations();
$incl_header->Operations();
$incl_left_panel->Operations();
$content->Operation();
$meta_tag->Operation();
//End Execute Components

//Go to destination page @1-717442DE
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_header->Class_Terminate();
    unset($incl_header);
    $incl_left_panel->Class_Terminate();
    unset($incl_left_panel);
    unset($book_showcase);
    unset($content);
    unset($scroller);
    unset($meta_tag);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-8B4BF2FE
$incl_footer->Show();
$incl_header->Show();
$incl_left_panel->Show();
$book_showcase->Show();
$content->Show();
$scroller->Show();
$meta_tag->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-D0F5935D
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_header->Class_Terminate();
unset($incl_header);
$incl_left_panel->Class_Terminate();
unset($incl_left_panel);
unset($book_showcase);
unset($content);
unset($scroller);
unset($meta_tag);
unset($Tpl);
//End Unload Page


?>
