<?php
//Include Common Files @1-ABB205AC
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "package_link_builder.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-1B12872F
include_once(RelativePath . "/incl_ClixTop.php");
//End Include Page implementation



//Include Page implementation @24-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

//Include Page implementation @26-B92CD63A
include_once(RelativePath . "/incl_sidebar.php");
//End Include Page implementation



class clsRecordclix_record { //clix_record Class @200-3B378BE4

//Variables @200-D6FF3E86

    // Public variables
    var $ComponentType = "Record";
    var $ComponentName;
    var $Parent;
    var $HTMLFormAction;
    var $PressedButton;
    var $Errors;
    var $ErrorBlock;
    var $FormSubmitted;
    var $FormEnctype;
    var $Visible;
    var $IsEmpty;

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";

    var $InsertAllowed = false;
    var $UpdateAllowed = false;
    var $DeleteAllowed = false;
    var $ReadAllowed   = false;
    var $EditMode      = false;
    var $ds;
    var $DataSource;
    var $ValidatingControls;
    var $Controls;
    var $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @200-4E03F74E
    function clsRecordclix_record($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record clix_record/Error";
        $this->DataSource = new clsclix_recordDataSource($this);
        $this->ds = & $this->DataSource;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "clix_record";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = & new clsButton("Button_Insert", $Method, $this);
            $this->Button_Update = & new clsButton("Button_Update", $Method, $this);
            $this->Button_Delete = & new clsButton("Button_Delete", $Method, $this);
            $this->Button_Cancel = & new clsButton("Button_Cancel", $Method, $this);
            $this->caption = & new clsControl(ccsLabel, "caption", "caption", ccsText, "", CCGetRequestParam("caption", $Method, NULL), $this);
            $this->caption->HTML = true;
            $this->category_name = & new clsControl(ccsHidden, "category_name", "Category Name", ccsText, "", CCGetRequestParam("category_name", $Method, NULL), $this);
            $this->category_name->Required = true;
            $this->AvailableListBox = & new clsControl(ccsListBox, "AvailableListBox", "AvailableListBox", ccsInteger, "", CCGetRequestParam("AvailableListBox", $Method, NULL), $this);
            $this->AvailableListBox->Multiple = true;
            $this->AvailableListBox->DSType = dsTable;
            $this->AvailableListBox->DataSource = new clsDBConnection1();
            $this->AvailableListBox->ds = & $this->AvailableListBox->DataSource;
            $this->AvailableListBox->DataSource->SQL = "SELECT category_id, category_name \n" .
"FROM w_directory_categories {SQL_Where} {SQL_OrderBy}";
            $this->AvailableListBox->DataSource->Order = "category_name";
            list($this->AvailableListBox->BoundColumn, $this->AvailableListBox->TextColumn, $this->AvailableListBox->DBFormat) = array("category_id", "category_name", "");
            $this->AvailableListBox->DataSource->Parameters["expr240"] = 8;
            $this->AvailableListBox->DataSource->wp = new clsSQLParameters();
            $this->AvailableListBox->DataSource->wp->AddParameter("1", "expr240", ccsInteger, "", "", $this->AvailableListBox->DataSource->Parameters["expr240"], "", false);
            $this->AvailableListBox->DataSource->wp->Criterion[1] = $this->AvailableListBox->DataSource->wp->Operation(opEqual, "category_id_parent", $this->AvailableListBox->DataSource->wp->GetDBValue("1"), $this->AvailableListBox->DataSource->ToSQL($this->AvailableListBox->DataSource->wp->GetDBValue("1"), ccsInteger),false);
            $this->AvailableListBox->DataSource->Where = 
                 $this->AvailableListBox->DataSource->wp->Criterion[1];
            $this->AvailableListBox->DataSource->Order = "category_name";
            $this->RightButton = & new clsButton("RightButton", $Method, $this);
            $this->LeftButton = & new clsButton("LeftButton", $Method, $this);
            $this->LinkedListBox = & new clsControl(ccsListBox, "LinkedListBox", "LinkedListBox", ccsInteger, "", CCGetRequestParam("LinkedListBox", $Method, NULL), $this);
            $this->LinkedListBox->Multiple = true;
            $this->LinkedListBox->DSType = dsTable;
            $this->LinkedListBox->DataSource = new clsDBConnection1();
            $this->LinkedListBox->ds = & $this->LinkedListBox->DataSource;
            $this->LinkedListBox->DataSource->SQL = "SELECT w_directory_categories.* \n" .
"FROM w_directory_categories INNER JOIN link_visit_package ON\n" .
"w_directory_categories.category_id = link_visit_package.package {SQL_Where} {SQL_OrderBy}";
            $this->LinkedListBox->DataSource->Order = "category_name";
            list($this->LinkedListBox->BoundColumn, $this->LinkedListBox->TextColumn, $this->LinkedListBox->DBFormat) = array("category_id", "category_name", "");
            $this->LinkedListBox->DataSource->Parameters["urle~"] = CCGetFromGet("e~", NULL);
            $this->LinkedListBox->DataSource->wp = new clsSQLParameters();
            $this->LinkedListBox->DataSource->wp->AddParameter("1", "urle~", ccsInteger, "", "", $this->LinkedListBox->DataSource->Parameters["urle~"], -1, false);
            $this->LinkedListBox->DataSource->wp->Criterion[1] = $this->LinkedListBox->DataSource->wp->Operation(opEqual, "link_visit_package.natureofvisit", $this->LinkedListBox->DataSource->wp->GetDBValue("1"), $this->LinkedListBox->DataSource->ToSQL($this->LinkedListBox->DataSource->wp->GetDBValue("1"), ccsInteger),false);
            $this->LinkedListBox->DataSource->Where = 
                 $this->LinkedListBox->DataSource->wp->Criterion[1];
            $this->LinkedListBox->DataSource->Order = "category_name";
            $this->LinkedID = & new clsControl(ccsHidden, "LinkedID", "LinkedID", ccsText, "", CCGetRequestParam("LinkedID", $Method, NULL), $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @200-354A1FF4
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urle~"] = CCGetFromGet("e~", NULL);
    }
//End Initialize Method

//Validate Method @200-B827F822
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->category_name->Validate() && $Validation);
        $Validation = ($this->AvailableListBox->Validate() && $Validation);
        $Validation = ($this->LinkedListBox->Validate() && $Validation);
        $Validation = ($this->LinkedID->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->category_name->Errors->Count() == 0);
        $Validation =  $Validation && ($this->AvailableListBox->Errors->Count() == 0);
        $Validation =  $Validation && ($this->LinkedListBox->Errors->Count() == 0);
        $Validation =  $Validation && ($this->LinkedID->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @200-CB6ADB06
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->caption->Errors->Count());
        $errors = ($errors || $this->category_name->Errors->Count());
        $errors = ($errors || $this->AvailableListBox->Errors->Count());
        $errors = ($errors || $this->LinkedListBox->Errors->Count());
        $errors = ($errors || $this->LinkedID->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @200-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @200-AD7CE7BA
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = $this->EditMode ? "Button_Update" : "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            } else if($this->Button_Delete->Pressed) {
                $this->PressedButton = "Button_Delete";
            } else if($this->Button_Cancel->Pressed) {
                $this->PressedButton = "Button_Cancel";
            } else if($this->RightButton->Pressed) {
                $this->PressedButton = "RightButton";
            } else if($this->LeftButton->Pressed) {
                $this->PressedButton = "LeftButton";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "e~", "d~", "n~"));
        if($this->PressedButton == "Button_Delete") {
            if(!CCGetEvent($this->Button_Delete->CCSEvents, "OnClick", $this->Button_Delete)) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "Button_Cancel") {
            if(!CCGetEvent($this->Button_Cancel->CCSEvents, "OnClick", $this->Button_Cancel)) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "RightButton") {
            if(!CCGetEvent($this->RightButton->CCSEvents, "OnClick", $this->RightButton)) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "LeftButton") {
            if(!CCGetEvent($this->LeftButton->CCSEvents, "OnClick", $this->LeftButton)) {
                $Redirect = "";
            }
        } else if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert)) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update) || !$this->UpdateRow()) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//UpdateRow Method @200-07ACC621
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->caption->SetValue($this->caption->GetValue(true));
        $this->DataSource->category_name->SetValue($this->category_name->GetValue(true));
        $this->DataSource->LinkedID->SetValue($this->LinkedID->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @200-F5830531
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->AvailableListBox->Prepare();
        $this->LinkedListBox->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                if(!$this->FormSubmitted){
                    $this->category_name->SetValue($this->DataSource->category_name->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->caption->Errors->ToString());
            $Error = ComposeStrings($Error, $this->category_name->Errors->ToString());
            $Error = ComposeStrings($Error, $this->AvailableListBox->Errors->ToString());
            $Error = ComposeStrings($Error, $this->LinkedListBox->Errors->ToString());
            $Error = ComposeStrings($Error, $this->LinkedID->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Insert->Visible = !$this->EditMode && $this->InsertAllowed;
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;
        $this->Button_Delete->Visible = $this->EditMode && $this->DeleteAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Update->Show();
        $this->Button_Delete->Show();
        $this->Button_Cancel->Show();
        $this->caption->Show();
        $this->category_name->Show();
        $this->AvailableListBox->Show();
        $this->RightButton->Show();
        $this->LeftButton->Show();
        $this->LinkedListBox->Show();
        $this->LinkedID->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End clix_record Class @200-FCB6E20C

class clsclix_recordDataSource extends clsDBConnection1 {  //clix_recordDataSource Class @200-F5D18A1F

//DataSource Variables @200-584321C2
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $UpdateParameters;
    var $wp;
    var $AllParametersSet;

    var $UpdateFields = array();

    // Datasource fields
    var $caption;
    var $category_name;
    var $AvailableListBox;
    var $LinkedListBox;
    var $LinkedID;
//End DataSource Variables

//DataSourceClass_Initialize Event @200-7B7509AE
    function clsclix_recordDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record clix_record/Error";
        $this->Initialize();
        $this->caption = new clsField("caption", ccsText, "");
        
        $this->category_name = new clsField("category_name", ccsText, "");
        
        $this->AvailableListBox = new clsField("AvailableListBox", ccsInteger, "");
        
        $this->LinkedListBox = new clsField("LinkedListBox", ccsInteger, "");
        
        $this->LinkedID = new clsField("LinkedID", ccsText, "");
        

        $this->UpdateFields["category_name"] = array("Name" => "category_name", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @200-020CF312
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urle~", ccsInteger, "", "", $this->Parameters["urle~"], -1, false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "category_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @200-F78FCDCC
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT category_name \n\n" .
        "FROM w_directory_categories {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @200-28E53211
    function SetValues()
    {
        $this->category_name->SetDBValue($this->f("category_name"));
    }
//End SetValues Method

//Update Method @200-9DB95843
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["category_name"]["Value"] = $this->category_name->GetDBValue(true);
        $this->SQL = CCBuildUpdate("w_directory_categories", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End clix_recordDataSource Class @200-FCB6E20C

class clsDirectoryclix_list { //clix_list class @78-CC3F5E12

//Variables @78-E1DD9A99

    // Public variables
    var $Parent;
    var $ComponentType = "Directory";
    var $ComponentName;
    var $Visible;
    var $Errors;
    var $ErrorBlock;
    var $ds;
    var $DataSource;
    var $IsEmpty;
    var $SorterName = "";
    var $SorterDirection = "";
    var $NumberOfColumns = 1;
    var $NumberOfSubcategories = "";

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";
    var $Attributes;
//End Variables

//Class_Initialize Event @78-7AF13D16
    function clsDirectoryclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Parent = & $Parent;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Directory clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->Visible = (CCSecurityAccessCheck("6666") == "success");

        $this->add_page = & new clsControl(ccsImageLink, "add_page", "add_page", ccsText, "", CCGetRequestParam("add_page", ccsGet, NULL), $this);
        $this->add_page->Page = "pages.php";
        $this->add_page->Visible = false;
        $this->edit = & new clsControl(ccsImageLink, "edit", "edit", ccsText, "", CCGetRequestParam("edit", ccsGet, NULL), $this);
        $this->edit->Page = "pages.php";
        $this->edit->Visible = false;
        $this->edit_prod = & new clsControl(ccsImageLink, "edit_prod", "edit_prod", ccsText, "", CCGetRequestParam("edit_prod", ccsGet, NULL), $this);
        $this->edit_prod->Page = "pages.php";
        $this->edit_prod->Visible = false;
        $this->cat_category_id = & new clsControl(ccsHidden, "cat_category_id", "cat_category_id", ccsInteger, "", CCGetRequestParam("cat_category_id", ccsGet, NULL), $this);
        $this->Link6 = & new clsControl(ccsImageLink, "Link6", "Link6", ccsText, "", CCGetRequestParam("Link6", ccsGet, NULL), $this);
        $this->Link6->Page = "pages.php";
        $this->Link6->Visible = false;
        $this->Link3 = & new clsControl(ccsImageLink, "Link3", "Link3", ccsText, "", CCGetRequestParam("Link3", ccsGet, NULL), $this);
        $this->Link3->Page = "package_link_builder.php";
        $this->Link5 = & new clsControl(ccsImageLink, "Link5", "Link5", ccsText, "", CCGetRequestParam("Link5", ccsGet, NULL), $this);
        $this->Link5->Page = "pages.php";
        $this->Link5->Visible = false;
        $this->SubcategoriesTailLink = & new clsControl(ccsLink, "SubcategoriesTailLink", "SubcategoriesTailLink", ccsText, "", CCGetRequestParam("SubcategoriesTailLink", ccsGet, NULL), $this);
        $this->SubcategoriesTailLink->Page = "sitemap.php";
        $this->Label1 = & new clsControl(ccsLabel, "Label1", "Label1", ccsText, "", CCGetRequestParam("Label1", ccsGet, NULL), $this);
        $this->Label1->HTML = true;
        $this->Label2 = & new clsControl(ccsLabel, "Label2", "Label2", ccsText, "", CCGetRequestParam("Label2", ccsGet, NULL), $this);
        $this->Label2->HTML = true;
        $this->SubcategoryLink = & new clsControl(ccsImageLink, "SubcategoryLink", "SubcategoryLink", ccsText, "", CCGetRequestParam("SubcategoryLink", ccsGet, NULL), $this);
        $this->SubcategoryLink->HTML = true;
        $this->SubcategoryLink->Page = "pages.php";
        $this->SubcategoryLink->Visible = false;
        $this->add_page_inac = & new clsControl(ccsImageLink, "add_page_inac", "add_page_inac", ccsText, "", CCGetRequestParam("add_page_inac", ccsGet, NULL), $this);
        $this->add_page_inac->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
        $this->add_page_inac->Page = "#";
        $this->add_page_inac->Visible = false;
        $this->sort2 = & new clsControl(ccsImageLink, "sort2", "sort2", ccsText, "", CCGetRequestParam("sort2", ccsGet, NULL), $this);
        $this->sort2->Page = "pages.php";
        $this->sort2->Visible = false;
        $this->sort1 = & new clsControl(ccsImageLink, "sort1", "sort1", ccsText, "", CCGetRequestParam("sort1", ccsGet, NULL), $this);
        $this->sort1->Page = "pages.php";
        $this->sort1->Visible = false;
        $this->Panelblack = & new clsPanel("Panelblack", $this);
        $this->Panelgreen = & new clsPanel("Panelgreen", $this);
        $this->cat_category_id2 = & new clsControl(ccsHidden, "cat_category_id2", "cat_category_id2", ccsInteger, "", CCGetRequestParam("cat_category_id2", ccsGet, NULL), $this);
        $this->seo2 = & new clsControl(ccsImageLink, "seo2", "seo2", ccsText, "", CCGetRequestParam("seo2", ccsGet, NULL), $this);
        $this->seo2->Page = "seo_pages.php";
        $this->seo2->Visible = false;
        $this->seo1 = & new clsControl(ccsImageLink, "seo1", "seo1", ccsText, "", CCGetRequestParam("seo1", ccsGet, NULL), $this);
        $this->seo1->Page = "seo_pages.php";
        $this->seo1->Visible = false;
    }
//End Class_Initialize Event

//Initialize Method @78-75D22D4D
    function Initialize()
    {
        if(!$this->Visible) return;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @78-6D9CEE1A
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;


        $this->DataSource->Parameters["expr115"] = 5;
        $this->DataSource->Parameters["expr117"] = Y;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->DataSource->Prepare();
        $this->DataSource->Open();

        $CategoriesNumber = 0;
        if($this->DataSource->next_record())
        {
            $this->IsEmpty = false;
            $category_id_value = $this->DataSource->f("cat_category_id");
            do {
                if($category_id_value != $this->DataSource->f("cat_category_id"))
                    $CategoriesNumber++;
                $category_id_value = $this->DataSource->f("cat_category_id");
            } while ($this->DataSource->next_record());
            $CategoriesNumber++;
        } else {
            $this->IsEmpty = true;
        }

        $this->DataSource->Open();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $this->Attributes->Show();
        $DirectoryBlock = "Directory " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;

        $ColumnNumber = 0;
        $CategoryNumber = 0;
        $NumberOfSubcategory = 0;

        $is_next_record = $this->DataSource->next_record();
        if($is_next_record)
        {
            do {
                $category_id_value = $this->DataSource->f("cat_category_id");
                $subcategory_id_value = $this->DataSource->f("sub_category_id");
                $this->DataSource->SetValues();
                $this->add_page->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->add_page->Parameters = CCAddParam($this->add_page->Parameters, "n~", $this->DataSource->f("cat_category_id"));
                $this->edit->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->edit->Parameters = CCAddParam($this->edit->Parameters, "e~", $this->DataSource->f("cat_category_id"));
                $this->edit->Parameters = CCAddParam($this->edit->Parameters, "ep~", $this->DataSource->f("sub_category_id_parent"));
                $this->edit_prod->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->edit_prod->Parameters = CCAddParam($this->edit_prod->Parameters, "e~", $this->DataSource->f("cat_category_id"));
                $this->edit_prod->Parameters = CCAddParam($this->edit_prod->Parameters, "ep~", $this->DataSource->f("sub_category_id_parent"));
                $this->cat_category_id->SetValue($this->DataSource->cat_category_id->GetValue());
                $this->Link6->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->Link6->Parameters = CCAddParam($this->Link6->Parameters, "n~", $this->DataSource->f("sub_category_id"));
                $this->Link3->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->Link3->Parameters = CCAddParam($this->Link3->Parameters, "e~", $this->DataSource->f("sub_category_id"));
                $this->Link5->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->Link5->Parameters = CCAddParam($this->Link5->Parameters, "d~", $this->DataSource->f("sub_category_id"));
                $this->SubcategoriesTailLink->SetValue($this->DataSource->SubcategoriesTailLink->GetValue());
                $this->SubcategoriesTailLink->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
                $this->SubcategoriesTailLink->Parameters = CCAddParam($this->SubcategoriesTailLink->Parameters, "category_id", $this->DataSource->f("cat_category_id"));
                $this->Label1->SetValue($this->DataSource->Label1->GetValue());
                $this->Label2->SetValue($this->DataSource->Label2->GetValue());
                $this->SubcategoryLink->SetValue($this->DataSource->SubcategoryLink->GetValue());
                $this->SubcategoryLink->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->SubcategoryLink->Parameters = CCAddParam($this->SubcategoryLink->Parameters, "cat", $this->DataSource->f("sub_category_id"));
                $this->sort2->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->sort2->Parameters = CCAddParam($this->sort2->Parameters, "ord~", $this->DataSource->f("sub_category_id"));
                $this->sort1->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "n~", "ord~", "ep~", "ccsForm"));
                $this->sort1->Parameters = CCAddParam($this->sort1->Parameters, "ord~", $this->DataSource->f("cat_category_id"));
                $this->cat_category_id2->SetValue($this->DataSource->cat_category_id2->GetValue());
                $this->seo2->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
                $this->seo2->Parameters = CCAddParam($this->seo2->Parameters, "ax", $this->DataSource->f("sub_category_id"));
                $this->seo1->Parameters = CCGetQueryString("QueryString", array("ccsForm"));
                $this->seo1->Parameters = CCAddParam($this->seo1->Parameters, "ax", $this->DataSource->f("cat_category_id"));
                if(strlen($subcategory_id_value)) $NumberOfSubcategory++;
                if($NumberOfSubcategory && (!strlen($this->NumberOfSubcategories) || $this->NumberOfSubcategories >= $NumberOfSubcategory)) {
                    $this->Attributes->Show();
                    $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowSubcategory", $this);
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/Category/Subcategory";
                    $this->Link6->Show();
                    $this->Link3->Show();
                    $this->Link5->Show();
                    $this->Label2->Show();
                    $this->SubcategoryLink->Show();
                    $this->sort2->Show();
                    $this->cat_category_id2->Show();
                    $this->seo2->Show();
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                    $Tpl->parse("Category/Subcategory", true);
                } else if(strlen($this->NumberOfSubcategories) && ($this->NumberOfSubcategories + 1) == $NumberOfSubcategory) {
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/Category/SubcategoriesTail";
                    $this->SubcategoriesTailLink->Show();
                    $this->Attributes->Show();
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                    $Tpl->parseto("Category/SubcategoriesTail", true, "Category/Subcategory");
                }
                $is_next_record = $this->DataSource->next_record();
                $parse_category = (($is_next_record && $category_id_value != $this->DataSource->f("cat_category_id")) || !$is_next_record);

                // Parse Separator
                if($parse_category) {
                    $CategoryNumber++;
                    $NumberOfSubcategory = 0;
                    $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowCategory", $this);
                    $this->Attributes->Show();
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/Category";
                    $this->add_page->Show();
                    $this->edit->Show();
                    $this->edit_prod->Show();
                    $this->cat_category_id->Show();
                    $this->Label1->Show();
                    $this->add_page_inac->Show();
                    $this->sort1->Show();
                    $this->Panelblack->Show();
                    $this->Panelgreen->Show();
                    $this->seo1->Show();
                    $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                    $Tpl->parse("Category", true);
                    $Tpl->setblockvar("Category/Subcategory", "");
                    if($CategoryNumber >= ($CategoriesNumber / ($this->NumberOfColumns - $ColumnNumber)) && $is_next_record) {
                        $CategoriesNumber -= $CategoryNumber;
                        $ColumnNumber++;
                        $CategoryNumber = 0;
                        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/ColumnSeparator";
                        $this->Attributes->Show();
                        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                        $Tpl->parseto("ColumnSeparator", true, "Category");
                    } else if($is_next_record) {
                        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock . "/CategorySeparator";
                        $this->Attributes->Show();
                        $Tpl->block_path = $ParentPath . "/" . $DirectoryBlock;
                        $Tpl->parseto("CategorySeparator", true, "Category");
                    }
                } else {
                    if(!strlen($this->NumberOfSubcategories) || $this->NumberOfSubcategories >= $NumberOfSubcategory) {
                        $this->Attributes->Show();
                        $Tpl->parseto("Category/SubcategorySeparator", true, "Category/Subcategory");
                    }
                }
            } while ($is_next_record);
        }
        else // Show NoCategories block if no categories are found
        {
            $this->Attributes->Show();
            $NoCategoriesParentPath = $Tpl->block_path;
            $Tpl->block_path = $NoCategoriesParentPath . "/NoCategories";
            $Tpl->block_path = $NoCategoriesParentPath;
            $Tpl->parse("NoCategories", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
    }
//End Show Method

//GetErrors Method @78-F9CFFCB4
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->add_page->Errors->ToString());
        $errors = ComposeStrings($errors, $this->edit->Errors->ToString());
        $errors = ComposeStrings($errors, $this->edit_prod->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_category_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Link6->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Link3->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Link5->Errors->ToString());
        $errors = ComposeStrings($errors, $this->SubcategoriesTailLink->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Label1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Label2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->SubcategoryLink->Errors->ToString());
        $errors = ComposeStrings($errors, $this->add_page_inac->Errors->ToString());
        $errors = ComposeStrings($errors, $this->sort2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->sort1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_category_id2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->seo2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->seo1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @78-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @78-E0C69A6C

//DataSource Variables @78-A57191A9
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $CountSQL;
    var $wp;


    // Datasource fields
    var $cat_category_id;
    var $SubcategoriesTailLink;
    var $Label1;
    var $Label2;
    var $SubcategoryLink;
    var $cat_category_id2;
//End DataSource Variables

//DataSourceClass_Initialize Event @78-A4E88AFB
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Directory clix_list";
        $this->Initialize();
        $this->cat_category_id = new clsField("cat_category_id", ccsInteger, "");
        
        $this->SubcategoriesTailLink = new clsField("SubcategoriesTailLink", ccsText, "");
        
        $this->Label1 = new clsField("Label1", ccsText, "");
        
        $this->Label2 = new clsField("Label2", ccsText, "");
        
        $this->SubcategoryLink = new clsField("SubcategoryLink", ccsText, "");
        
        $this->cat_category_id2 = new clsField("cat_category_id2", ccsInteger, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @78-698FE8E7
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "cat.sl_no, sub.sl_no";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            "");
    }
//End SetOrder Method

//Prepare Method @78-17110EE3
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "expr115", ccsInteger, "", "", $this->Parameters["expr115"], "", true);
        $this->wp->AddParameter("2", "expr117", ccsText, "", "", $this->Parameters["expr117"], -1, false);
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "cat.category_id_parent", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),true);
        $this->wp->Criterion[2] = $this->wp->Operation(opEqual, "cat.flg_tree", $this->wp->GetDBValue("2"), $this->ToSQL($this->wp->GetDBValue("2"), ccsText),false);
        $this->Where = $this->wp->opAND(
             false, 
             $this->wp->Criterion[1], 
             $this->wp->Criterion[2]);
    }
//End Prepare Method

//Open Method @78-07B7E005
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM w_directory_categories cat LEFT JOIN w_directory_categories sub ON\n\n" .
        "cat.category_id = sub.category_id_parent AND cat.lang_code = sub.lang_code";
        $this->SQL = "SELECT cat.category_id AS cat_category_id, cat.category_name AS cat_category_name, sub.category_id AS sub_category_id, sub.category_name AS sub_category_name,\n\n" .
        "cat.category_id_parent AS cat_category_id_parent, sub.category_id_parent AS sub_category_id_parent, concat(cat.link,'?cx = ',cat.category_name) AS my_link,\n\n" .
        "concat(sub.link,'?cx = ',sub.category_name) AS my_link_sub \n\n" .
        "FROM w_directory_categories cat LEFT JOIN w_directory_categories sub ON\n\n" .
        "cat.category_id = sub.category_id_parent AND cat.lang_code = sub.lang_code {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query(CCBuildSQL($this->SQL, $this->Where, $this->Order));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
        $this->MoveToPage($this->AbsolutePage);
    }
//End Open Method

//SetValues Method @78-70F3AEB0
    function SetValues()
    {
        $this->cat_category_id->SetDBValue(trim($this->f("cat_category_id")));
        $this->SubcategoriesTailLink->SetDBValue($this->f("cat_category_name"));
        $this->Label1->SetDBValue($this->f("cat_category_name"));
        $this->Label2->SetDBValue($this->f("sub_category_name"));
        $this->SubcategoryLink->SetDBValue($this->f("sub_category_name"));
        $this->cat_category_id2->SetDBValue(trim($this->f("sub_category_id")));
    }
//End SetValues Method

} //End clix_listDataSource Class @78-FCB6E20C











//Initialize Page @1-06265241
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "package_link_builder.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "./";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Authenticate User @1-74BBAD6F
CCSecurityRedirect("6666", "");
//End Authenticate User

//Include events file @1-0E5C0A58
include_once("./package_link_builder_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-9431DB90
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_ClixTop = & new clsincl_ClixTop("", "incl_ClixTop", $MainPage);
$incl_ClixTop->Initialize();
$incl_footer = & new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_sidebar = & new clsincl_sidebar("", "incl_sidebar", $MainPage);
$incl_sidebar->Initialize();
$clix_record = & new clsRecordclix_record("", $MainPage);
$clix_list = & new clsDirectoryclix_list("", $MainPage);
$MainPage->incl_ClixTop = & $incl_ClixTop;
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_sidebar = & $incl_sidebar;
$MainPage->clix_record = & $clix_record;
$MainPage->clix_list = & $clix_list;
$clix_record->Initialize();
$clix_list->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-51EC165D
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-2F8CEDD5
$incl_ClixTop->Operations();
$incl_footer->Operations();
$incl_sidebar->Operations();
$clix_record->Operation();
//End Execute Components

//Go to destination page @1-8DB9EB5B
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_ClixTop->Class_Terminate();
    unset($incl_ClixTop);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_sidebar->Class_Terminate();
    unset($incl_sidebar);
    unset($clix_record);
    unset($clix_list);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-840F2E3C
$incl_ClixTop->Show();
$incl_footer->Show();
$incl_sidebar->Show();
$clix_record->Show();
$clix_list->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-86B79017
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_ClixTop->Class_Terminate();
unset($incl_ClixTop);
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_sidebar->Class_Terminate();
unset($incl_sidebar);
unset($clix_record);
unset($clix_list);
unset($Tpl);
//End Unload Page


?>
