<?php
//Include Common Files @1-AEF6BDA2
define("RelativePath", ".");
define("PathToCurrentPage", "/");
define("FileName", "products.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

//Include Page implementation @2-1B12872F
include_once(RelativePath . "/incl_ClixTop.php");
//End Include Page implementation



//Include Page implementation @24-16DCDEFB
include_once(RelativePath . "/incl_footer.php");
//End Include Page implementation

//Include Page implementation @26-B92CD63A
include_once(RelativePath . "/incl_sidebar.php");
//End Include Page implementation

class clsGridclix_list { //clix_list class @27-9A031AD4

//Variables @27-0BCD9F8C

    // Public variables
    var $ComponentType = "Grid";
    var $ComponentName;
    var $Visible;
    var $Errors;
    var $ErrorBlock;
    var $ds;
    var $DataSource;
    var $PageSize;
    var $IsEmpty;
    var $ForceIteration = false;
    var $HasRecord = false;
    var $SorterName = "";
    var $SorterDirection = "";
    var $PageNumber;
    var $RowNumber;
    var $ControlsVisible = array();

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";
    var $Attributes;

    // Grid Controls
    var $StaticControls;
    var $RowControls;
    var $Sorter_product;
    var $Sorter_category;
    var $Sorter_new;
    var $Sorter_hot;
//End Variables

//Class_Initialize Event @27-DC553F07
    function clsGridclix_list($RelativePath, & $Parent)
    {
        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->ComponentName = "clix_list";
        $this->Visible = True;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Grid clix_list";
        $this->Attributes = new clsAttributes($this->ComponentName . ":");
        $this->DataSource = new clsclix_listDataSource($this);
        $this->ds = & $this->DataSource;
        $this->PageSize = CCGetParam($this->ComponentName . "PageSize", "");
        if(!is_numeric($this->PageSize) || !strlen($this->PageSize))
            $this->PageSize = 10;
        else
            $this->PageSize = intval($this->PageSize);
        if ($this->PageSize > 100)
            $this->PageSize = 100;
        if($this->PageSize == 0)
            $this->Errors->addError("<p>Form: Grid " . $this->ComponentName . "<br>Error: (CCS06) Invalid page size.</p>");
        $this->PageNumber = intval(CCGetParam($this->ComponentName . "Page", 1));
        if ($this->PageNumber <= 0) $this->PageNumber = 1;
        $this->SorterName = CCGetParam("clix_listOrder", "");
        $this->SorterDirection = CCGetParam("clix_listDir", "");

        $this->product = & new clsControl(ccsLabel, "product", "product", ccsText, "", CCGetRequestParam("product", ccsGet, NULL), $this);
        $this->ImageLink1 = & new clsControl(ccsImageLink, "ImageLink1", "ImageLink1", ccsText, "", CCGetRequestParam("ImageLink1", ccsGet, NULL), $this);
        $this->ImageLink1->Page = "products.php";
        $this->ImageLink2 = & new clsControl(ccsImageLink, "ImageLink2", "ImageLink2", ccsText, "", CCGetRequestParam("ImageLink2", ccsGet, NULL), $this);
        $this->ImageLink2->Parameters = CCGetQueryString("QueryString", array("n~", "e~", "ccsForm"));
        $this->ImageLink2->Page = "#";
        $this->product_id = & new clsControl(ccsHidden, "product_id", "product_id", ccsText, "", CCGetRequestParam("product_id", ccsGet, NULL), $this);
        $this->product_name = & new clsControl(ccsHidden, "product_name", "product_name", ccsText, "", CCGetRequestParam("product_name", ccsGet, NULL), $this);
        $this->cat_name = & new clsControl(ccsLabel, "cat_name", "cat_name", ccsText, "", CCGetRequestParam("cat_name", ccsGet, NULL), $this);
        $this->new_item = & new clsControl(ccsLabel, "new_item", "new_item", ccsText, "", CCGetRequestParam("new_item", ccsGet, NULL), $this);
        $this->hot_item = & new clsControl(ccsLabel, "hot_item", "hot_item", ccsText, "", CCGetRequestParam("hot_item", ccsGet, NULL), $this);
        $this->product_category_TotalRecords = & new clsControl(ccsLabel, "product_category_TotalRecords", "product_category_TotalRecords", ccsText, "", CCGetRequestParam("product_category_TotalRecords", ccsGet, NULL), $this);
        $this->Sorter_product = & new clsSorter($this->ComponentName, "Sorter_product", $FileName, $this);
        $this->Navigator = & new clsNavigator($this->ComponentName, "Navigator", $FileName, 10, tpSimple, $this);
        $this->Navigator->PageSizes = array("1", "5", "10", "25", "50");
        $this->ImageLink3 = & new clsControl(ccsImageLink, "ImageLink3", "ImageLink3", ccsText, "", CCGetRequestParam("ImageLink3", ccsGet, NULL), $this);
        $this->ImageLink3->Page = "products.php";
        $this->Sorter_category = & new clsSorter($this->ComponentName, "Sorter_category", $FileName, $this);
        $this->Sorter_new = & new clsSorter($this->ComponentName, "Sorter_new", $FileName, $this);
        $this->Sorter_hot = & new clsSorter($this->ComponentName, "Sorter_hot", $FileName, $this);
    }
//End Class_Initialize Event

//Initialize Method @27-90E704C5
    function Initialize()
    {
        if(!$this->Visible) return;

        $this->DataSource->PageSize = & $this->PageSize;
        $this->DataSource->AbsolutePage = & $this->PageNumber;
        $this->DataSource->SetOrder($this->SorterName, $this->SorterDirection);
    }
//End Initialize Method

//Show Method @27-69D4E6D2
    function Show()
    {
        global $Tpl;
        global $CCSLocales;
        if(!$this->Visible) return;

        $this->RowNumber = 0;


        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);


        $this->DataSource->Prepare();
        $this->DataSource->Open();
        $this->HasRecord = $this->DataSource->has_next_record();
        $this->IsEmpty = ! $this->HasRecord;
        $this->Attributes->Show();

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        if(!$this->Visible) return;

        $GridBlock = "Grid " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $GridBlock;


        if (!$this->IsEmpty) {
            $this->ControlsVisible["product"] = $this->product->Visible;
            $this->ControlsVisible["ImageLink1"] = $this->ImageLink1->Visible;
            $this->ControlsVisible["ImageLink2"] = $this->ImageLink2->Visible;
            $this->ControlsVisible["product_id"] = $this->product_id->Visible;
            $this->ControlsVisible["product_name"] = $this->product_name->Visible;
            $this->ControlsVisible["cat_name"] = $this->cat_name->Visible;
            $this->ControlsVisible["new_item"] = $this->new_item->Visible;
            $this->ControlsVisible["hot_item"] = $this->hot_item->Visible;
            while ($this->ForceIteration || (($this->RowNumber < $this->PageSize) &&  ($this->HasRecord = $this->DataSource->has_next_record()))) {
                $this->RowNumber++;
                if ($this->HasRecord) {
                    $this->DataSource->next_record();
                    $this->DataSource->SetValues();
                }
                $Tpl->block_path = $ParentPath . "/" . $GridBlock . "/Row";
                $this->product->SetValue($this->DataSource->product->GetValue());
                $this->ImageLink1->Parameters = CCGetQueryString("QueryString", array("n~", "d~", "ccsForm"));
                $this->ImageLink1->Parameters = CCAddParam($this->ImageLink1->Parameters, "e~", $this->DataSource->f("product_id"));
                $this->product_id->SetValue($this->DataSource->product_id->GetValue());
                $this->product_name->SetValue($this->DataSource->product_name->GetValue());
                $this->cat_name->SetValue($this->DataSource->cat_name->GetValue());
                $this->new_item->SetValue($this->DataSource->new_item->GetValue());
                $this->hot_item->SetValue($this->DataSource->hot_item->GetValue());
                $this->Attributes->SetValue("rowNumber", $this->RowNumber);
                $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShowRow", $this);
                $this->Attributes->Show();
                $this->product->Show();
                $this->ImageLink1->Show();
                $this->ImageLink2->Show();
                $this->product_id->Show();
                $this->product_name->Show();
                $this->cat_name->Show();
                $this->new_item->Show();
                $this->hot_item->Show();
                $Tpl->block_path = $ParentPath . "/" . $GridBlock;
                $Tpl->parse("Row", true);
            }
        }
        else { // Show NoRecords block if no records are found
            $this->Attributes->Show();
            $Tpl->parse("NoRecords", false);
        }

        $errors = $this->GetErrors();
        if(strlen($errors))
        {
            $Tpl->replaceblock("", $errors);
            $Tpl->block_path = $ParentPath;
            return;
        }
        $this->Navigator->PageNumber = $this->DataSource->AbsolutePage;
        $this->Navigator->PageSize = $this->PageSize;
        if ($this->DataSource->RecordsCount == "CCS not counted")
            $this->Navigator->TotalPages = $this->DataSource->AbsolutePage + ($this->DataSource->next_record() ? 1 : 0);
        else
            $this->Navigator->TotalPages = $this->DataSource->PageCount();
        if ($this->Navigator->TotalPages <= 1) {
            $this->Navigator->Visible = false;
        }
        $this->ImageLink3->Parameters = CCGetQueryString("QueryString", array("e~", "d~", "ccsForm"));
        $this->ImageLink3->Parameters = CCAddParam($this->ImageLink3->Parameters, "n~", 1);
        $this->product_category_TotalRecords->Show();
        $this->Sorter_product->Show();
        $this->Navigator->Show();
        $this->ImageLink3->Show();
        $this->Sorter_category->Show();
        $this->Sorter_new->Show();
        $this->Sorter_hot->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

//GetErrors Method @27-939658C7
    function GetErrors()
    {
        $errors = "";
        $errors = ComposeStrings($errors, $this->product->Errors->ToString());
        $errors = ComposeStrings($errors, $this->ImageLink1->Errors->ToString());
        $errors = ComposeStrings($errors, $this->ImageLink2->Errors->ToString());
        $errors = ComposeStrings($errors, $this->product_id->Errors->ToString());
        $errors = ComposeStrings($errors, $this->product_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->cat_name->Errors->ToString());
        $errors = ComposeStrings($errors, $this->new_item->Errors->ToString());
        $errors = ComposeStrings($errors, $this->hot_item->Errors->ToString());
        $errors = ComposeStrings($errors, $this->Errors->ToString());
        $errors = ComposeStrings($errors, $this->DataSource->Errors->ToString());
        return $errors;
    }
//End GetErrors Method

} //End clix_list Class @27-FCB6E20C

class clsclix_listDataSource extends clsDBConnection1 {  //clix_listDataSource Class @27-E0C69A6C

//DataSource Variables @27-AAE9E23F
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $CountSQL;
    var $wp;


    // Datasource fields
    var $product;
    var $product_id;
    var $product_name;
    var $cat_name;
    var $new_item;
    var $hot_item;
//End DataSource Variables

//DataSourceClass_Initialize Event @27-154053A9
    function clsclix_listDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Grid clix_list";
        $this->Initialize();
        $this->product = new clsField("product", ccsText, "");
        
        $this->product_id = new clsField("product_id", ccsText, "");
        
        $this->product_name = new clsField("product_name", ccsText, "");
        
        $this->cat_name = new clsField("cat_name", ccsText, "");
        
        $this->new_item = new clsField("new_item", ccsText, "");
        
        $this->hot_item = new clsField("hot_item", ccsText, "");
        

    }
//End DataSourceClass_Initialize Event

//SetOrder Method @27-68522162
    function SetOrder($SorterName, $SorterDirection)
    {
        $this->Order = "product_id desc";
        $this->Order = CCGetOrder($this->Order, $SorterName, $SorterDirection, 
            array("Sorter_product" => array("product_name", ""), 
            "Sorter_category" => array("cat_name", ""), 
            "Sorter_new" => array("new_item", ""), 
            "Sorter_hot" => array("hot_item", "")));
    }
//End SetOrder Method

//Prepare Method @27-14D6CD9D
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
    }
//End Prepare Method

//Open Method @27-13BE3EC0
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->CountSQL = "SELECT COUNT(*)\n\n" .
        "FROM product_category INNER JOIN product ON\n\n" .
        "product_category.cat_id = product.category_id";
        $this->SQL = "SELECT cat_name, product_name, product_id, hot_item, new_item \n\n" .
        "FROM product_category INNER JOIN product ON\n\n" .
        "product_category.cat_id = product.category_id {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        if ($this->CountSQL) 
            $this->RecordsCount = CCGetDBValue(CCBuildSQL($this->CountSQL, $this->Where, ""), $this);
        else
            $this->RecordsCount = "CCS not counted";
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @27-7D6C2486
    function SetValues()
    {
        $this->product->SetDBValue($this->f("product_name"));
        $this->product_id->SetDBValue($this->f("product_id"));
        $this->product_name->SetDBValue($this->f("product_name"));
        $this->cat_name->SetDBValue($this->f("cat_name"));
        $this->new_item->SetDBValue($this->f("new_item"));
        $this->hot_item->SetDBValue($this->f("hot_item"));
    }
//End SetValues Method

} //End clix_listDataSource Class @27-FCB6E20C

class clsRecordclix_rec { //clix_rec Class @48-E00062A6

//Variables @48-D6FF3E86

    // Public variables
    var $ComponentType = "Record";
    var $ComponentName;
    var $Parent;
    var $HTMLFormAction;
    var $PressedButton;
    var $Errors;
    var $ErrorBlock;
    var $FormSubmitted;
    var $FormEnctype;
    var $Visible;
    var $IsEmpty;

    var $CCSEvents = "";
    var $CCSEventResult;

    var $RelativePath = "";

    var $InsertAllowed = false;
    var $UpdateAllowed = false;
    var $DeleteAllowed = false;
    var $ReadAllowed   = false;
    var $EditMode      = false;
    var $ds;
    var $DataSource;
    var $ValidatingControls;
    var $Controls;
    var $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @48-703185F3
    function clsRecordclix_rec($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->DataSource = new clsclix_recDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "clix_rec";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "multipart/form-data";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = & new clsButton("Button_Insert", $Method, $this);
            $this->Button_Update = & new clsButton("Button_Update", $Method, $this);
            $this->Button_Delete = & new clsButton("Button_Delete", $Method, $this);
            $this->Button_Cancel = & new clsButton("Button_Cancel", $Method, $this);
            $this->product_name = & new clsControl(ccsTextBox, "product_name", "Product Name", ccsText, "", CCGetRequestParam("product_name", $Method, NULL), $this);
            $this->product_name->Required = true;
            $this->new_item = & new clsControl(ccsRadioButton, "new_item", "New Product", ccsText, "", CCGetRequestParam("new_item", $Method, NULL), $this);
            $this->new_item->DSType = dsListOfValues;
            $this->new_item->Values = array(array("Y", "Yes"), array("N", "No"));
            $this->new_item->HTML = true;
            $this->new_item->Required = true;
            $this->product_detail = & new clsControl(ccsTextArea, "product_detail", "Product Description", ccsText, "", CCGetRequestParam("product_detail", $Method, NULL), $this);
            $this->hot_item = & new clsControl(ccsRadioButton, "hot_item", "Hot Product", ccsText, "", CCGetRequestParam("hot_item", $Method, NULL), $this);
            $this->hot_item->DSType = dsListOfValues;
            $this->hot_item->Values = array(array("Y", "Yes"), array("N", "No"));
            $this->hot_item->HTML = true;
            $this->hot_item->Required = true;
            $this->caption = & new clsControl(ccsLabel, "caption", "caption", ccsText, "", CCGetRequestParam("caption", $Method, NULL), $this);
            $this->caption->HTML = true;
            $this->category_id = & new clsControl(ccsListBox, "category_id", "Product Category", ccsInteger, "", CCGetRequestParam("category_id", $Method, NULL), $this);
            $this->category_id->DSType = dsTable;
            $this->category_id->DataSource = new clsDBConnection1();
            $this->category_id->ds = & $this->category_id->DataSource;
            $this->category_id->DataSource->SQL = "SELECT cat_id, cat_name \n" .
"FROM product_category {SQL_Where} {SQL_OrderBy}";
            $this->category_id->DataSource->Order = "cat_name";
            list($this->category_id->BoundColumn, $this->category_id->TextColumn, $this->category_id->DBFormat) = array("", "", "");
            $this->category_id->DataSource->Order = "cat_name";
            $this->category_id->Required = true;
            $this->Image1 = & new clsControl(ccsImage, "Image1", "Image1", ccsText, "", CCGetRequestParam("Image1", $Method, NULL), $this);
            $this->Image2 = & new clsControl(ccsImage, "Image2", "Image2", ccsText, "", CCGetRequestParam("Image2", $Method, NULL), $this);
            $this->image_thumb = & new clsFileUpload("image_thumb", "Thumb Image", "../temp_images/", "../clix_images/", "*.gif;*.jpg;*.png", "", 500000, $this);
            $this->image_thumb->Required = true;
            $this->image_full = & new clsFileUpload("image_full", "Full Image", "../temp_images/", "../clix_images/", "*.gif;*.jpg;*.png", "", 500000, $this);
            $this->image_full->Required = true;
            if(!$this->FormSubmitted) {
                if(!is_array($this->new_item->Value) && !strlen($this->new_item->Value) && $this->new_item->Value !== false)
                    $this->new_item->SetText(N);
                if(!is_array($this->hot_item->Value) && !strlen($this->hot_item->Value) && $this->hot_item->Value !== false)
                    $this->hot_item->SetText(N);
            }
            if(!is_array($this->caption->Value) && !strlen($this->caption->Value) && $this->caption->Value !== false)
                $this->caption->SetText($CCSLocales->GetText("Text3"));
        }
    }
//End Class_Initialize Event

//Initialize Method @48-354A1FF4
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["urle~"] = CCGetFromGet("e~", NULL);
    }
//End Initialize Method

//Validate Method @48-DEB3CCAE
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->product_name->Validate() && $Validation);
        $Validation = ($this->new_item->Validate() && $Validation);
        $Validation = ($this->product_detail->Validate() && $Validation);
        $Validation = ($this->hot_item->Validate() && $Validation);
        $Validation = ($this->category_id->Validate() && $Validation);
        $Validation = ($this->image_thumb->Validate() && $Validation);
        $Validation = ($this->image_full->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->product_name->Errors->Count() == 0);
        $Validation =  $Validation && ($this->new_item->Errors->Count() == 0);
        $Validation =  $Validation && ($this->product_detail->Errors->Count() == 0);
        $Validation =  $Validation && ($this->hot_item->Errors->Count() == 0);
        $Validation =  $Validation && ($this->category_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->image_thumb->Errors->Count() == 0);
        $Validation =  $Validation && ($this->image_full->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @48-819CD9C6
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->product_name->Errors->Count());
        $errors = ($errors || $this->new_item->Errors->Count());
        $errors = ($errors || $this->product_detail->Errors->Count());
        $errors = ($errors || $this->hot_item->Errors->Count());
        $errors = ($errors || $this->caption->Errors->Count());
        $errors = ($errors || $this->category_id->Errors->Count());
        $errors = ($errors || $this->Image1->Errors->Count());
        $errors = ($errors || $this->Image2->Errors->Count());
        $errors = ($errors || $this->image_thumb->Errors->Count());
        $errors = ($errors || $this->image_full->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @48-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @48-40692E64
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        $this->image_thumb->Upload();
        $this->image_full->Upload();

        if($this->FormSubmitted) {
            $this->PressedButton = $this->EditMode ? "Button_Update" : "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            } else if($this->Button_Delete->Pressed) {
                $this->PressedButton = "Button_Delete";
            } else if($this->Button_Cancel->Pressed) {
                $this->PressedButton = "Button_Cancel";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm", "e~", "d~", "n~"));
        if($this->PressedButton == "Button_Delete") {
            if(!CCGetEvent($this->Button_Delete->CCSEvents, "OnClick", $this->Button_Delete)) {
                $Redirect = "";
            }
        } else if($this->PressedButton == "Button_Cancel") {
            if(!CCGetEvent($this->Button_Cancel->CCSEvents, "OnClick", $this->Button_Cancel)) {
                $Redirect = "";
            }
        } else if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert) || !$this->InsertRow()) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update) || !$this->UpdateRow()) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @48-B80AD744
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->product_name->SetValue($this->product_name->GetValue(true));
        $this->DataSource->new_item->SetValue($this->new_item->GetValue(true));
        $this->DataSource->product_detail->SetValue($this->product_detail->GetValue(true));
        $this->DataSource->hot_item->SetValue($this->hot_item->GetValue(true));
        $this->DataSource->caption->SetValue($this->caption->GetValue(true));
        $this->DataSource->category_id->SetValue($this->category_id->GetValue(true));
        $this->DataSource->Image1->SetValue($this->Image1->GetValue(true));
        $this->DataSource->Image2->SetValue($this->Image2->GetValue(true));
        $this->DataSource->image_thumb->SetValue($this->image_thumb->GetValue(true));
        $this->DataSource->image_full->SetValue($this->image_full->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        if($this->DataSource->Errors->Count() == 0) {
            $this->image_thumb->Move();
            $this->image_full->Move();
        }
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @48-AF25C333
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->product_name->SetValue($this->product_name->GetValue(true));
        $this->DataSource->new_item->SetValue($this->new_item->GetValue(true));
        $this->DataSource->product_detail->SetValue($this->product_detail->GetValue(true));
        $this->DataSource->hot_item->SetValue($this->hot_item->GetValue(true));
        $this->DataSource->caption->SetValue($this->caption->GetValue(true));
        $this->DataSource->category_id->SetValue($this->category_id->GetValue(true));
        $this->DataSource->Image1->SetValue($this->Image1->GetValue(true));
        $this->DataSource->Image2->SetValue($this->Image2->GetValue(true));
        $this->DataSource->image_thumb->SetValue($this->image_thumb->GetValue(true));
        $this->DataSource->image_full->SetValue($this->image_full->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        if($this->DataSource->Errors->Count() == 0) {
            $this->image_thumb->Move();
            $this->image_full->Move();
        }
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @48-05749130
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->new_item->Prepare();
        $this->hot_item->Prepare();
        $this->category_id->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                $this->Image1->SetValue($this->DataSource->Image1->GetValue());
                $this->Image2->SetValue($this->DataSource->Image2->GetValue());
                if(!$this->FormSubmitted){
                    $this->product_name->SetValue($this->DataSource->product_name->GetValue());
                    $this->new_item->SetValue($this->DataSource->new_item->GetValue());
                    $this->product_detail->SetValue($this->DataSource->product_detail->GetValue());
                    $this->hot_item->SetValue($this->DataSource->hot_item->GetValue());
                    $this->category_id->SetValue($this->DataSource->category_id->GetValue());
                    $this->image_thumb->SetValue($this->DataSource->image_thumb->GetValue());
                    $this->image_full->SetValue($this->DataSource->image_full->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->product_name->Errors->ToString());
            $Error = ComposeStrings($Error, $this->new_item->Errors->ToString());
            $Error = ComposeStrings($Error, $this->product_detail->Errors->ToString());
            $Error = ComposeStrings($Error, $this->hot_item->Errors->ToString());
            $Error = ComposeStrings($Error, $this->caption->Errors->ToString());
            $Error = ComposeStrings($Error, $this->category_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Image1->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Image2->Errors->ToString());
            $Error = ComposeStrings($Error, $this->image_thumb->Errors->ToString());
            $Error = ComposeStrings($Error, $this->image_full->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Insert->Visible = !$this->EditMode && $this->InsertAllowed;
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;
        $this->Button_Delete->Visible = $this->EditMode && $this->DeleteAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Update->Show();
        $this->Button_Delete->Show();
        $this->Button_Cancel->Show();
        $this->product_name->Show();
        $this->new_item->Show();
        $this->product_detail->Show();
        $this->hot_item->Show();
        $this->caption->Show();
        $this->category_id->Show();
        $this->Image1->Show();
        $this->Image2->Show();
        $this->image_thumb->Show();
        $this->image_full->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End clix_rec Class @48-FCB6E20C

class clsclix_recDataSource extends clsDBConnection1 {  //clix_recDataSource Class @48-1EF28E83

//DataSource Variables @48-50FECA12
    var $Parent = "";
    var $CCSEvents = "";
    var $CCSEventResult;
    var $ErrorBlock;
    var $CmdExecution;

    var $InsertParameters;
    var $UpdateParameters;
    var $wp;
    var $AllParametersSet;

    var $InsertFields = array();
    var $UpdateFields = array();

    // Datasource fields
    var $product_name;
    var $new_item;
    var $product_detail;
    var $hot_item;
    var $caption;
    var $category_id;
    var $Image1;
    var $Image2;
    var $image_thumb;
    var $image_full;
//End DataSource Variables

//DataSourceClass_Initialize Event @48-324B31B9
    function clsclix_recDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record clix_rec/Error";
        $this->Initialize();
        $this->product_name = new clsField("product_name", ccsText, "");
        
        $this->new_item = new clsField("new_item", ccsText, "");
        
        $this->product_detail = new clsField("product_detail", ccsText, "");
        
        $this->hot_item = new clsField("hot_item", ccsText, "");
        
        $this->caption = new clsField("caption", ccsText, "");
        
        $this->category_id = new clsField("category_id", ccsInteger, "");
        
        $this->Image1 = new clsField("Image1", ccsText, "");
        
        $this->Image2 = new clsField("Image2", ccsText, "");
        
        $this->image_thumb = new clsField("image_thumb", ccsText, "");
        
        $this->image_full = new clsField("image_full", ccsText, "");
        

        $this->InsertFields["product_name"] = array("Name" => "product_name", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["new_item"] = array("Name" => "new_item", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["product_detail"] = array("Name" => "product_detail", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["hot_item"] = array("Name" => "hot_item", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["category_id"] = array("Name" => "category_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->InsertFields["image_thumb"] = array("Name" => "image_thumb", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["image_full"] = array("Name" => "image_full", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["product_name"] = array("Name" => "product_name", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["new_item"] = array("Name" => "new_item", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["product_detail"] = array("Name" => "product_detail", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["hot_item"] = array("Name" => "hot_item", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["category_id"] = array("Name" => "category_id", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["image_thumb"] = array("Name" => "image_thumb", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["image_full"] = array("Name" => "image_full", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @48-DF3455FA
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "urle~", ccsInteger, "", "", $this->Parameters["urle~"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "product_id", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @48-D5D2C673
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM product {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @48-D69521D2
    function SetValues()
    {
        $this->product_name->SetDBValue($this->f("product_name"));
        $this->new_item->SetDBValue($this->f("new_item"));
        $this->product_detail->SetDBValue($this->f("product_detail"));
        $this->hot_item->SetDBValue($this->f("hot_item"));
        $this->category_id->SetDBValue(trim($this->f("category_id")));
        $this->Image1->SetDBValue($this->f("image_thumb"));
        $this->Image2->SetDBValue($this->f("image_full"));
        $this->image_thumb->SetDBValue($this->f("image_thumb"));
        $this->image_full->SetDBValue($this->f("image_full"));
    }
//End SetValues Method

//Insert Method @48-E42F12CF
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        $this->InsertFields["product_name"]["Value"] = $this->product_name->GetDBValue(true);
        $this->InsertFields["new_item"]["Value"] = $this->new_item->GetDBValue(true);
        $this->InsertFields["product_detail"]["Value"] = $this->product_detail->GetDBValue(true);
        $this->InsertFields["hot_item"]["Value"] = $this->hot_item->GetDBValue(true);
        $this->InsertFields["category_id"]["Value"] = $this->category_id->GetDBValue(true);
        $this->InsertFields["image_thumb"]["Value"] = $this->image_thumb->GetDBValue(true);
        $this->InsertFields["image_full"]["Value"] = $this->image_full->GetDBValue(true);
        $this->SQL = CCBuildInsert("product", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @48-8ECF06BA
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["product_name"]["Value"] = $this->product_name->GetDBValue(true);
        $this->UpdateFields["new_item"]["Value"] = $this->new_item->GetDBValue(true);
        $this->UpdateFields["product_detail"]["Value"] = $this->product_detail->GetDBValue(true);
        $this->UpdateFields["hot_item"]["Value"] = $this->hot_item->GetDBValue(true);
        $this->UpdateFields["category_id"]["Value"] = $this->category_id->GetDBValue(true);
        $this->UpdateFields["image_thumb"]["Value"] = $this->image_thumb->GetDBValue(true);
        $this->UpdateFields["image_full"]["Value"] = $this->image_full->GetDBValue(true);
        $this->SQL = CCBuildUpdate("product", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End clix_recDataSource Class @48-FCB6E20C











//Initialize Page @1-91324D24
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "products.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "./";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Authenticate User @1-74BBAD6F
CCSecurityRedirect("6666", "");
//End Authenticate User

//Include events file @1-7A9001EA
include_once("./products_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-5B0637B3
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$incl_ClixTop = & new clsincl_ClixTop("", "incl_ClixTop", $MainPage);
$incl_ClixTop->Initialize();
$incl_footer = & new clsincl_footer("", "incl_footer", $MainPage);
$incl_footer->Initialize();
$incl_sidebar = & new clsincl_sidebar("", "incl_sidebar", $MainPage);
$incl_sidebar->Initialize();
$clix_list = & new clsGridclix_list("", $MainPage);
$clix_rec = & new clsRecordclix_rec("", $MainPage);
$MainPage->incl_ClixTop = & $incl_ClixTop;
$MainPage->incl_footer = & $incl_footer;
$MainPage->incl_sidebar = & $incl_sidebar;
$MainPage->clix_list = & $clix_list;
$MainPage->clix_rec = & $clix_rec;
$clix_list->Initialize();
$clix_rec->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-51EC165D
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-F0606FE4
$incl_ClixTop->Operations();
$incl_footer->Operations();
$incl_sidebar->Operations();
$clix_rec->Operation();
//End Execute Components

//Go to destination page @1-788A201D
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    $incl_ClixTop->Class_Terminate();
    unset($incl_ClixTop);
    $incl_footer->Class_Terminate();
    unset($incl_footer);
    $incl_sidebar->Class_Terminate();
    unset($incl_sidebar);
    unset($clix_list);
    unset($clix_rec);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-A7A75B9D
$incl_ClixTop->Show();
$incl_footer->Show();
$incl_sidebar->Show();
$clix_list->Show();
$clix_rec->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-F854B87C
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
$incl_ClixTop->Class_Terminate();
unset($incl_ClixTop);
$incl_footer->Class_Terminate();
unset($incl_footer);
$incl_sidebar->Class_Terminate();
unset($incl_sidebar);
unset($clix_list);
unset($clix_rec);
unset($Tpl);
//End Unload Page


?>
