<?php
//Include Common Files @1-7AC4546E
define("RelativePath", "..");
define("PathToCurrentPage", "/hotel_front/");
define("FileName", "checkout_customer.php");
include_once(RelativePath . "/Common.php");
include_once(RelativePath . "/Template.php");
include_once(RelativePath . "/Sorter.php");
include_once(RelativePath . "/Navigator.php");
//End Include Common Files

class clsRecordclient_email { //client_email Class @2-70812448

//Variables @2-9E315808

    // Public variables
    public $ComponentType = "Record";
    public $ComponentName;
    public $Parent;
    public $HTMLFormAction;
    public $PressedButton;
    public $Errors;
    public $ErrorBlock;
    public $FormSubmitted;
    public $FormEnctype;
    public $Visible;
    public $IsEmpty;

    public $CCSEvents = "";
    public $CCSEventResult;

    public $RelativePath = "";

    public $InsertAllowed = false;
    public $UpdateAllowed = false;
    public $DeleteAllowed = false;
    public $ReadAllowed   = false;
    public $EditMode      = false;
    public $ds;
    public $DataSource;
    public $ValidatingControls;
    public $Controls;
    public $Attributes;

    // Class variables
//End Variables

//Class_Initialize Event @2-76AA806F
    function clsRecordclient_email($RelativePath, & $Parent)
    {

        global $FileName;
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->Visible = true;
        $this->Parent = & $Parent;
        $this->RelativePath = $RelativePath;
        $this->Errors = new clsErrors();
        $this->ErrorBlock = "Record client_email/Error";
        $this->DataSource = new clsclient_emailDataSource($this);
        $this->ds = & $this->DataSource;
        $this->InsertAllowed = true;
        $this->UpdateAllowed = true;
        $this->ReadAllowed = true;
        if($this->Visible)
        {
            $this->ComponentName = "client_email";
            $this->Attributes = new clsAttributes($this->ComponentName . ":");
            $CCSForm = explode(":", CCGetFromGet("ccsForm", ""), 2);
            if(sizeof($CCSForm) == 1)
                $CCSForm[1] = "";
            list($FormName, $FormMethod) = $CCSForm;
            $this->EditMode = ($FormMethod == "Edit");
            $this->FormEnctype = "application/x-www-form-urlencoded";
            $this->FormSubmitted = ($FormName == $this->ComponentName);
            $Method = $this->FormSubmitted ? ccsPost : ccsGet;
            $this->Button_Insert = new clsButton("Button_Insert", $Method, $this);
            $this->Button_Update = new clsButton("Button_Update", $Method, $this);
            $this->login_id = new clsControl(ccsTextBox, "login_id", "Login Id", ccsText, "", CCGetRequestParam("login_id", $Method, NULL), $this);
            $this->login_id->Required = true;
            $this->name = new clsControl(ccsTextBox, "name", "Name", ccsText, "", CCGetRequestParam("name", $Method, NULL), $this);
            $this->name->Required = true;
            $this->dob = new clsControl(ccsTextBox, "dob", "Date of Birth", ccsDate, array("dd", "/", "mm", "/", "yyyy"), CCGetRequestParam("dob", $Method, NULL), $this);
            $this->dob->Required = true;
            $this->sex = new clsControl(ccsRadioButton, "sex", "Sex", ccsInteger, "", CCGetRequestParam("sex", $Method, NULL), $this);
            $this->sex->DSType = dsTable;
            $this->sex->DataSource = new clsDBConnection1();
            $this->sex->ds = & $this->sex->DataSource;
            $this->sex->DataSource->SQL = "SELECT * \n" .
"FROM mst_sex {SQL_Where} {SQL_OrderBy}";
            list($this->sex->BoundColumn, $this->sex->TextColumn, $this->sex->DBFormat) = array("id", "desc", "");
            $this->sex->Required = true;
            $this->DatePicker_dob1 = new clsDatePicker("DatePicker_dob1", "client_email", "dob", $this);
            $this->flg_enable = new clsControl(ccsHidden, "flg_enable", "flg_enable", ccsText, "", CCGetRequestParam("flg_enable", $Method, NULL), $this);
        }
    }
//End Class_Initialize Event

//Initialize Method @2-7FB029A0
    function Initialize()
    {

        if(!$this->Visible)
            return;

        $this->DataSource->Parameters["sesclix_client_code"] = CCGetSession("clix_client_code", NULL);
    }
//End Initialize Method

//Validate Method @2-6CA9B3E8
    function Validate()
    {
        global $CCSLocales;
        $Validation = true;
        $Where = "";
        $Validation = ($this->login_id->Validate() && $Validation);
        $Validation = ($this->name->Validate() && $Validation);
        $Validation = ($this->dob->Validate() && $Validation);
        $Validation = ($this->sex->Validate() && $Validation);
        $Validation = ($this->flg_enable->Validate() && $Validation);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "OnValidate", $this);
        $Validation =  $Validation && ($this->login_id->Errors->Count() == 0);
        $Validation =  $Validation && ($this->name->Errors->Count() == 0);
        $Validation =  $Validation && ($this->dob->Errors->Count() == 0);
        $Validation =  $Validation && ($this->sex->Errors->Count() == 0);
        $Validation =  $Validation && ($this->flg_enable->Errors->Count() == 0);
        return (($this->Errors->Count() == 0) && $Validation);
    }
//End Validate Method

//CheckErrors Method @2-7A8CD85A
    function CheckErrors()
    {
        $errors = false;
        $errors = ($errors || $this->login_id->Errors->Count());
        $errors = ($errors || $this->name->Errors->Count());
        $errors = ($errors || $this->dob->Errors->Count());
        $errors = ($errors || $this->sex->Errors->Count());
        $errors = ($errors || $this->DatePicker_dob1->Errors->Count());
        $errors = ($errors || $this->flg_enable->Errors->Count());
        $errors = ($errors || $this->Errors->Count());
        $errors = ($errors || $this->DataSource->Errors->Count());
        return $errors;
    }
//End CheckErrors Method

//MasterDetail @2-ED598703
function SetPrimaryKeys($keyArray)
{
    $this->PrimaryKeys = $keyArray;
}
function GetPrimaryKeys()
{
    return $this->PrimaryKeys;
}
function GetPrimaryKey($keyName)
{
    return $this->PrimaryKeys[$keyName];
}
//End MasterDetail

//Operation Method @2-E955BD63
    function Operation()
    {
        if(!$this->Visible)
            return;

        global $Redirect;
        global $FileName;

        $this->DataSource->Prepare();
        if(!$this->FormSubmitted) {
            $this->EditMode = $this->DataSource->AllParametersSet;
            return;
        }

        if($this->FormSubmitted) {
            $this->PressedButton = $this->EditMode ? "Button_Update" : "Button_Insert";
            if($this->Button_Insert->Pressed) {
                $this->PressedButton = "Button_Insert";
            } else if($this->Button_Update->Pressed) {
                $this->PressedButton = "Button_Update";
            }
        }
        $Redirect = $FileName . "?" . CCGetQueryString("QueryString", array("ccsForm"));
        if($this->Validate()) {
            if($this->PressedButton == "Button_Insert") {
                if(!CCGetEvent($this->Button_Insert->CCSEvents, "OnClick", $this->Button_Insert) || !$this->InsertRow()) {
                    $Redirect = "";
                }
            } else if($this->PressedButton == "Button_Update") {
                if(!CCGetEvent($this->Button_Update->CCSEvents, "OnClick", $this->Button_Update) || !$this->UpdateRow()) {
                    $Redirect = "";
                }
            }
        } else {
            $Redirect = "";
        }
        if ($Redirect)
            $this->DataSource->close();
    }
//End Operation Method

//InsertRow Method @2-C8798661
    function InsertRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeInsert", $this);
        if(!$this->InsertAllowed) return false;
        $this->DataSource->login_id->SetValue($this->login_id->GetValue(true));
        $this->DataSource->name->SetValue($this->name->GetValue(true));
        $this->DataSource->dob->SetValue($this->dob->GetValue(true));
        $this->DataSource->sex->SetValue($this->sex->GetValue(true));
        $this->DataSource->flg_enable->SetValue($this->flg_enable->GetValue(true));
        $this->DataSource->Insert();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterInsert", $this);
        return (!$this->CheckErrors());
    }
//End InsertRow Method

//UpdateRow Method @2-337103A9
    function UpdateRow()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeUpdate", $this);
        if(!$this->UpdateAllowed) return false;
        $this->DataSource->login_id->SetValue($this->login_id->GetValue(true));
        $this->DataSource->name->SetValue($this->name->GetValue(true));
        $this->DataSource->dob->SetValue($this->dob->GetValue(true));
        $this->DataSource->sex->SetValue($this->sex->GetValue(true));
        $this->DataSource->flg_enable->SetValue($this->flg_enable->GetValue(true));
        $this->DataSource->Update();
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterUpdate", $this);
        return (!$this->CheckErrors());
    }
//End UpdateRow Method

//Show Method @2-EA305115
    function Show()
    {
        global $CCSUseAmp;
        global $Tpl;
        global $FileName;
        global $CCSLocales;
        $Error = "";

        if(!$this->Visible)
            return;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeSelect", $this);

        $this->sex->Prepare();

        $RecordBlock = "Record " . $this->ComponentName;
        $ParentPath = $Tpl->block_path;
        $Tpl->block_path = $ParentPath . "/" . $RecordBlock;
        $this->EditMode = $this->EditMode && $this->ReadAllowed;
        if($this->EditMode) {
            if($this->DataSource->Errors->Count()){
                $this->Errors->AddErrors($this->DataSource->Errors);
                $this->DataSource->Errors->clear();
            }
            $this->DataSource->Open();
            if($this->DataSource->Errors->Count() == 0 && $this->DataSource->next_record()) {
                $this->DataSource->SetValues();
                if(!$this->FormSubmitted){
                    $this->login_id->SetValue($this->DataSource->login_id->GetValue());
                    $this->name->SetValue($this->DataSource->name->GetValue());
                    $this->dob->SetValue($this->DataSource->dob->GetValue());
                    $this->sex->SetValue($this->DataSource->sex->GetValue());
                }
            } else {
                $this->EditMode = false;
            }
        }
        if (!$this->FormSubmitted) {
        }

        if($this->FormSubmitted || $this->CheckErrors()) {
            $Error = "";
            $Error = ComposeStrings($Error, $this->login_id->Errors->ToString());
            $Error = ComposeStrings($Error, $this->name->Errors->ToString());
            $Error = ComposeStrings($Error, $this->dob->Errors->ToString());
            $Error = ComposeStrings($Error, $this->sex->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DatePicker_dob1->Errors->ToString());
            $Error = ComposeStrings($Error, $this->flg_enable->Errors->ToString());
            $Error = ComposeStrings($Error, $this->Errors->ToString());
            $Error = ComposeStrings($Error, $this->DataSource->Errors->ToString());
            $Tpl->SetVar("Error", $Error);
            $Tpl->Parse("Error", false);
        }
        $CCSForm = $this->EditMode ? $this->ComponentName . ":" . "Edit" : $this->ComponentName;
        $this->HTMLFormAction = $FileName . "?" . CCAddParam(CCGetQueryString("QueryString", ""), "ccsForm", $CCSForm);
        $Tpl->SetVar("Action", !$CCSUseAmp ? $this->HTMLFormAction : str_replace("&", "&amp;", $this->HTMLFormAction));
        $Tpl->SetVar("HTMLFormName", $this->ComponentName);
        $Tpl->SetVar("HTMLFormEnctype", $this->FormEnctype);
        $this->Button_Insert->Visible = !$this->EditMode && $this->InsertAllowed;
        $this->Button_Update->Visible = $this->EditMode && $this->UpdateAllowed;

        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeShow", $this);
        $this->Attributes->Show();
        if(!$this->Visible) {
            $Tpl->block_path = $ParentPath;
            return;
        }

        $this->Button_Insert->Show();
        $this->Button_Update->Show();
        $this->login_id->Show();
        $this->name->Show();
        $this->dob->Show();
        $this->sex->Show();
        $this->DatePicker_dob1->Show();
        $this->flg_enable->Show();
        $Tpl->parse();
        $Tpl->block_path = $ParentPath;
        $this->DataSource->close();
    }
//End Show Method

} //End client_email Class @2-FCB6E20C

class clsclient_emailDataSource extends clsDBConnection1 {  //client_emailDataSource Class @2-C00C9473

//DataSource Variables @2-02239398
    public $Parent = "";
    public $CCSEvents = "";
    public $CCSEventResult;
    public $ErrorBlock;
    public $CmdExecution;

    public $InsertParameters;
    public $UpdateParameters;
    public $wp;
    public $AllParametersSet;

    public $InsertFields = array();
    public $UpdateFields = array();

    // Datasource fields
    public $login_id;
    public $name;
    public $dob;
    public $sex;
    public $flg_enable;
//End DataSource Variables

//DataSourceClass_Initialize Event @2-28D2F24E
    function clsclient_emailDataSource(& $Parent)
    {
        $this->Parent = & $Parent;
        $this->ErrorBlock = "Record client_email/Error";
        $this->Initialize();
        $this->login_id = new clsField("login_id", ccsText, "");
        
        $this->name = new clsField("name", ccsText, "");
        
        $this->dob = new clsField("dob", ccsDate, array("yyyy", "-", "mm", "-", "dd", " ", "HH", ":", "nn", ":", "ss"));
        
        $this->sex = new clsField("sex", ccsInteger, "");
        
        $this->flg_enable = new clsField("flg_enable", ccsText, "");
        

        $this->InsertFields["login_id"] = array("Name" => "login_id", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["name"] = array("Name" => "name", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->InsertFields["dob"] = array("Name" => "dob", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->InsertFields["sex"] = array("Name" => "sex", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
        $this->UpdateFields["login_id"] = array("Name" => "login_id", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["name"] = array("Name" => "name", "Value" => "", "DataType" => ccsText, "OmitIfEmpty" => 1);
        $this->UpdateFields["dob"] = array("Name" => "dob", "Value" => "", "DataType" => ccsDate, "OmitIfEmpty" => 1);
        $this->UpdateFields["sex"] = array("Name" => "sex", "Value" => "", "DataType" => ccsInteger, "OmitIfEmpty" => 1);
    }
//End DataSourceClass_Initialize Event

//Prepare Method @2-ECA2F7EE
    function Prepare()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->wp = new clsSQLParameters($this->ErrorBlock);
        $this->wp->AddParameter("1", "sesclix_client_code", ccsInteger, "", "", $this->Parameters["sesclix_client_code"], "", false);
        $this->AllParametersSet = $this->wp->AllParamsSet();
        $this->wp->Criterion[1] = $this->wp->Operation(opEqual, "client_code", $this->wp->GetDBValue("1"), $this->ToSQL($this->wp->GetDBValue("1"), ccsInteger),false);
        $this->Where = 
             $this->wp->Criterion[1];
    }
//End Prepare Method

//Open Method @2-EEA7E372
    function Open()
    {
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildSelect", $this->Parent);
        $this->SQL = "SELECT * \n\n" .
        "FROM store_client {SQL_Where} {SQL_OrderBy}";
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteSelect", $this->Parent);
        $this->PageSize = 1;
        $this->query($this->OptimizeSQL(CCBuildSQL($this->SQL, $this->Where, $this->Order)));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteSelect", $this->Parent);
    }
//End Open Method

//SetValues Method @2-FB02667E
    function SetValues()
    {
        $this->login_id->SetDBValue($this->f("login_id"));
        $this->name->SetDBValue($this->f("name"));
        $this->dob->SetDBValue(trim($this->f("dob")));
        $this->sex->SetDBValue(trim($this->f("sex")));
    }
//End SetValues Method

//Insert Method @2-509A0F9E
    function Insert()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildInsert", $this->Parent);
        $this->InsertFields["login_id"]["Value"] = $this->login_id->GetDBValue(true);
        $this->InsertFields["name"]["Value"] = $this->name->GetDBValue(true);
        $this->InsertFields["dob"]["Value"] = $this->dob->GetDBValue(true);
        $this->InsertFields["sex"]["Value"] = $this->sex->GetDBValue(true);
        $this->SQL = CCBuildInsert("store_client", $this->InsertFields, $this);
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteInsert", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteInsert", $this->Parent);
        }
    }
//End Insert Method

//Update Method @2-15D33203
    function Update()
    {
        global $CCSLocales;
        global $DefaultDateFormat;
        $this->CmdExecution = true;
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeBuildUpdate", $this->Parent);
        $this->UpdateFields["login_id"]["Value"] = $this->login_id->GetDBValue(true);
        $this->UpdateFields["name"]["Value"] = $this->name->GetDBValue(true);
        $this->UpdateFields["dob"]["Value"] = $this->dob->GetDBValue(true);
        $this->UpdateFields["sex"]["Value"] = $this->sex->GetDBValue(true);
        $this->SQL = CCBuildUpdate("store_client", $this->UpdateFields, $this);
        $this->SQL .= strlen($this->Where) ? " WHERE " . $this->Where : $this->Where;
        if (!strlen($this->Where) && $this->Errors->Count() == 0) 
            $this->Errors->addError($CCSLocales->GetText("CCS_CustomOperationError_MissingParameters"));
        $this->CCSEventResult = CCGetEvent($this->CCSEvents, "BeforeExecuteUpdate", $this->Parent);
        if($this->Errors->Count() == 0 && $this->CmdExecution) {
            $this->query($this->SQL);
            $this->CCSEventResult = CCGetEvent($this->CCSEvents, "AfterExecuteUpdate", $this->Parent);
        }
    }
//End Update Method

} //End client_emailDataSource Class @2-FCB6E20C

//Initialize Page @1-3FA6D56F
// Variables
$FileName = "";
$Redirect = "";
$Tpl = "";
$TemplateFileName = "";
$BlockToParse = "";
$ComponentName = "";
$Attributes = "";

// Events;
$CCSEvents = "";
$CCSEventResult = "";

$FileName = FileName;
$Redirect = "";
$TemplateFileName = "checkout_customer.html";
$BlockToParse = "main";
$TemplateEncoding = "UTF-8";
$ContentType = "text/html";
$PathToRoot = "../";
$Charset = $Charset ? $Charset : "utf-8";
//End Initialize Page

//Include events file @1-3C0B2CA3
include_once("./checkout_customer_events.php");
//End Include events file

//Before Initialize @1-E870CEBC
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeInitialize", $MainPage);
//End Before Initialize

//Initialize Objects @1-62411C5F
$DBConnection1 = new clsDBConnection1();
$MainPage->Connections["Connection1"] = & $DBConnection1;
$Attributes = new clsAttributes("page:");
$MainPage->Attributes = & $Attributes;

// Controls
$client_email = new clsRecordclient_email("", $MainPage);
$MainPage->client_email = & $client_email;
$client_email->Initialize();

BindEvents();

$CCSEventResult = CCGetEvent($CCSEvents, "AfterInitialize", $MainPage);

if ($Charset) {
    header("Content-Type: " . $ContentType . "; charset=" . $Charset);
} else {
    header("Content-Type: " . $ContentType);
}
//End Initialize Objects

//Initialize HTML Template @1-FD7047F5
$CCSEventResult = CCGetEvent($CCSEvents, "OnInitializeView", $MainPage);
$Tpl = new clsTemplate($FileEncoding, $TemplateEncoding);
$Tpl->LoadTemplate(PathToCurrentPage . $TemplateFileName, $BlockToParse, "UTF-8", "replace");
$Tpl->block_path = "/$BlockToParse";
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeShow", $MainPage);
$Attributes->SetValue("pathToRoot", "../");
$Attributes->Show();
//End Initialize HTML Template

//Execute Components @1-0365CD9D
$client_email->Operation();
//End Execute Components

//Go to destination page @1-F41F2C44
if($Redirect)
{
    $CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
    $DBConnection1->close();
    header("Location: " . $Redirect);
    unset($client_email);
    unset($Tpl);
    exit;
}
//End Go to destination page

//Show Page @1-B162B1E2
$client_email->Show();
$Tpl->block_path = "";
$Tpl->Parse($BlockToParse, false);
if (!isset($main_block)) $main_block = $Tpl->GetVar($BlockToParse);
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeOutput", $MainPage);
if ($CCSEventResult) echo $main_block;
//End Show Page

//Unload Page @1-9A05FFA2
$CCSEventResult = CCGetEvent($CCSEvents, "BeforeUnload", $MainPage);
$DBConnection1->close();
unset($client_email);
unset($Tpl);
//End Unload Page


?>
